/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.loading;

import java.io.File;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.org.apache.druid.segment.loading.LeastBytesUsedStorageLocationSelectorStrategy;
import org.apache.hive.druid.org.apache.druid.segment.loading.StorageLocation;
import org.apache.hive.druid.org.apache.druid.segment.loading.StorageLocationConfig;
import org.apache.hive.druid.org.apache.druid.segment.loading.StorageLocationSelectorStrategy;
import org.apache.hive.druid.org.apache.druid.utils.JvmUtils;
import org.hibernate.validator.constraints.NotEmpty;

public class SegmentLoaderConfig {
    @JsonProperty
    @NotEmpty
    private List<StorageLocationConfig> locations = null;
    @JsonProperty(value="lazyLoadOnStart")
    private boolean lazyLoadOnStart = false;
    @JsonProperty(value="deleteOnRemove")
    private boolean deleteOnRemove = true;
    @JsonProperty(value="dropSegmentDelayMillis")
    private int dropSegmentDelayMillis = (int)TimeUnit.SECONDS.toMillis(30L);
    @JsonProperty(value="announceIntervalMillis")
    private int announceIntervalMillis = 0;
    @JsonProperty(value="numLoadingThreads")
    private int numLoadingThreads = JvmUtils.getRuntimeInfo().getAvailableProcessors();
    @JsonProperty(value="numBootstrapThreads")
    private Integer numBootstrapThreads = null;
    @JsonProperty(value="locationSelectorStrategy")
    private StorageLocationSelectorStrategy locationSelectorStrategy;
    @JsonProperty
    private File infoDir = null;
    @JsonProperty
    private int statusQueueMaxSize = 100;

    public List<StorageLocationConfig> getLocations() {
        return this.locations;
    }

    public boolean isLazyLoadOnStart() {
        return this.lazyLoadOnStart;
    }

    public boolean isDeleteOnRemove() {
        return this.deleteOnRemove;
    }

    public int getDropSegmentDelayMillis() {
        return this.dropSegmentDelayMillis;
    }

    public int getAnnounceIntervalMillis() {
        return this.announceIntervalMillis;
    }

    public int getNumLoadingThreads() {
        return this.numLoadingThreads;
    }

    public int getNumBootstrapThreads() {
        return this.numBootstrapThreads == null ? this.numLoadingThreads : this.numBootstrapThreads;
    }

    public StorageLocationSelectorStrategy getStorageLocationSelectorStrategy(List<StorageLocation> storageLocations) {
        if (this.locationSelectorStrategy == null) {
            this.locationSelectorStrategy = new LeastBytesUsedStorageLocationSelectorStrategy(storageLocations);
        }
        return this.locationSelectorStrategy;
    }

    public File getInfoDir() {
        if (this.infoDir == null) {
            this.infoDir = new File(this.locations.get(0).getPath(), "info_dir");
        }
        return this.infoDir;
    }

    public int getStatusQueueMaxSize() {
        return this.statusQueueMaxSize;
    }

    public SegmentLoaderConfig withLocations(List<StorageLocationConfig> locations) {
        SegmentLoaderConfig retVal = new SegmentLoaderConfig();
        retVal.locations = Lists.newArrayList(locations);
        retVal.deleteOnRemove = this.deleteOnRemove;
        retVal.infoDir = this.infoDir;
        return retVal;
    }

    @VisibleForTesting
    SegmentLoaderConfig withStorageLocationSelectorStrategy(StorageLocationSelectorStrategy strategy) {
        this.locationSelectorStrategy = strategy;
        return this;
    }

    public String toString() {
        return "SegmentLoaderConfig{locations=" + this.locations + ", deleteOnRemove=" + this.deleteOnRemove + ", dropSegmentDelayMillis=" + this.dropSegmentDelayMillis + ", locationSelectorStrategy=" + this.locationSelectorStrategy + ", infoDir=" + this.infoDir + '}';
    }
}

