/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.loading;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hive.druid.org.apache.druid.segment.loading.StorageLocation;
import org.apache.hive.druid.org.apache.druid.segment.loading.StorageLocationSelectorStrategy;

public class RoundRobinStorageLocationSelectorStrategy
implements StorageLocationSelectorStrategy {
    private final List<StorageLocation> storageLocations;
    private final AtomicInteger startIndex = new AtomicInteger(0);

    public RoundRobinStorageLocationSelectorStrategy(List<StorageLocation> storageLocations) {
        this.storageLocations = storageLocations;
    }

    @Override
    public Iterator<StorageLocation> getLocations() {
        return new Iterator<StorageLocation>(){
            private final int numStorageLocations;
            private int remainingIterations;
            private int i;
            {
                this.remainingIterations = this.numStorageLocations = RoundRobinStorageLocationSelectorStrategy.this.storageLocations.size();
                this.i = RoundRobinStorageLocationSelectorStrategy.this.startIndex.getAndUpdate(n -> (n + 1) % this.numStorageLocations);
            }

            @Override
            public boolean hasNext() {
                return this.remainingIterations > 0;
            }

            @Override
            public StorageLocation next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                --this.remainingIterations;
                StorageLocation nextLocation = (StorageLocation)RoundRobinStorageLocationSelectorStrategy.this.storageLocations.get(this.i++);
                if (this.i == this.numStorageLocations) {
                    this.i = 0;
                }
                return nextLocation;
            }
        };
    }
}

