/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.incremental;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.segment.DimensionIndexer;
import org.apache.hive.druid.org.apache.druid.segment.incremental.IncrementalIndex;

public final class IncrementalIndexRow {
    public static final int EMPTY_ROW_INDEX = -1;
    final long timestamp;
    final Object[] dims;
    private final List<IncrementalIndex.DimensionDesc> dimensionDescsList;
    private int rowIndex;
    private long dimsKeySize;

    IncrementalIndexRow(long timestamp, Object[] dims, List<IncrementalIndex.DimensionDesc> dimensionDescsList) {
        this(timestamp, dims, dimensionDescsList, -1);
    }

    IncrementalIndexRow(long timestamp, Object[] dims, List<IncrementalIndex.DimensionDesc> dimensionDescsList, int rowIndex) {
        this.timestamp = timestamp;
        this.dims = dims;
        this.dimensionDescsList = dimensionDescsList;
        this.rowIndex = rowIndex;
    }

    private IncrementalIndexRow(long timestamp, Object[] dims, List<IncrementalIndex.DimensionDesc> dimensionDescsList, long dimsKeySize) {
        this.timestamp = timestamp;
        this.dims = dims;
        this.dimensionDescsList = dimensionDescsList;
        this.dimsKeySize = dimsKeySize;
    }

    static IncrementalIndexRow createTimeAndDimswithDimsKeySize(long timestamp, Object[] dims, List<IncrementalIndex.DimensionDesc> dimensionDescsList, long dimsKeySize) {
        return new IncrementalIndexRow(timestamp, dims, dimensionDescsList, dimsKeySize);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Object[] getDims() {
        return this.dims;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    void setRowIndex(int rowIndex) {
        this.rowIndex = rowIndex;
    }

    public long estimateBytesInMemory() {
        long sizeInBytes = 8 + 4 * this.dims.length + 8 + 8;
        return sizeInBytes += this.dimsKeySize;
    }

    public String toString() {
        return "IncrementalIndexRow{timestamp=" + DateTimes.utc(this.timestamp) + ", dims=" + Lists.transform(Arrays.asList(this.dims), new Function<Object, Object>(){

            @Override
            public Object apply(@Nullable Object input) {
                if (input == null || Array.getLength(input) == 0) {
                    return Collections.singletonList("null");
                }
                return Collections.singletonList(input);
            }
        }) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IncrementalIndexRow that = (IncrementalIndexRow)o;
        if (this.timestamp != that.timestamp) {
            return false;
        }
        if (this.dims.length != that.dims.length) {
            return false;
        }
        for (int i = 0; i < this.dims.length; ++i) {
            DimensionIndexer indexer = this.dimensionDescsList.get(i).getIndexer();
            if (indexer.checkUnsortedEncodedKeyComponentsEqual(this.dims[i], that.dims[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = (int)this.timestamp;
        for (int i = 0; i < this.dims.length; ++i) {
            DimensionIndexer indexer = this.dimensionDescsList.get(i).getIndexer();
            hash = 31 * hash + indexer.getUnsortedEncodedKeyComponentHashCode(this.dims[i]);
        }
        return hash;
    }
}

