/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.filter;

import java.util.Set;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.query.BitmapResultFactory;
import org.apache.hive.druid.org.apache.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.org.apache.druid.query.filter.BitmapIndexSelector;
import org.apache.hive.druid.org.apache.druid.query.filter.DruidDoublePredicate;
import org.apache.hive.druid.org.apache.druid.query.filter.DruidFloatPredicate;
import org.apache.hive.druid.org.apache.druid.query.filter.DruidLongPredicate;
import org.apache.hive.druid.org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.hive.druid.org.apache.druid.query.filter.Filter;
import org.apache.hive.druid.org.apache.druid.query.filter.FilterTuning;
import org.apache.hive.druid.org.apache.druid.query.filter.ValueMatcher;
import org.apache.hive.druid.org.apache.druid.query.filter.vector.VectorValueMatcher;
import org.apache.hive.druid.org.apache.druid.query.filter.vector.VectorValueMatcherColumnStrategizer;
import org.apache.hive.druid.org.apache.druid.segment.ColumnSelector;
import org.apache.hive.druid.org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.hive.druid.org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.hive.druid.org.apache.druid.segment.filter.Filters;
import org.apache.hive.druid.org.apache.druid.segment.vector.VectorColumnSelectorFactory;

public class DimensionPredicateFilter
implements Filter {
    private final String dimension;
    private final DruidPredicateFactory predicateFactory;
    private final String basePredicateString;
    private final ExtractionFn extractionFn;
    private final FilterTuning filterTuning;

    public DimensionPredicateFilter(String dimension, DruidPredicateFactory predicateFactory, ExtractionFn extractionFn) {
        this(dimension, predicateFactory, extractionFn, null);
    }

    public DimensionPredicateFilter(String dimension, final DruidPredicateFactory predicateFactory, final ExtractionFn extractionFn, FilterTuning filterTuning) {
        Preconditions.checkNotNull(predicateFactory, "predicateFactory");
        this.dimension = Preconditions.checkNotNull(dimension, "dimension");
        this.basePredicateString = predicateFactory.toString();
        this.extractionFn = extractionFn;
        this.filterTuning = filterTuning;
        this.predicateFactory = extractionFn == null ? predicateFactory : new DruidPredicateFactory(){
            final Predicate<String> baseStringPredicate;
            {
                this.baseStringPredicate = predicateFactory.makeStringPredicate();
            }

            @Override
            public Predicate<String> makeStringPredicate() {
                return input -> this.baseStringPredicate.apply(extractionFn.apply((String)input));
            }

            @Override
            public DruidLongPredicate makeLongPredicate() {
                return input -> this.baseStringPredicate.apply(extractionFn.apply(input));
            }

            @Override
            public DruidFloatPredicate makeFloatPredicate() {
                return input -> this.baseStringPredicate.apply(extractionFn.apply(Float.valueOf(input)));
            }

            @Override
            public DruidDoublePredicate makeDoublePredicate() {
                return input -> this.baseStringPredicate.apply(extractionFn.apply(input));
            }
        };
    }

    @Override
    public <T> T getBitmapResult(BitmapIndexSelector selector, BitmapResultFactory<T> bitmapResultFactory) {
        return Filters.matchPredicate(this.dimension, selector, bitmapResultFactory, this.predicateFactory.makeStringPredicate());
    }

    @Override
    public ValueMatcher makeMatcher(ColumnSelectorFactory factory) {
        return Filters.makeValueMatcher(factory, this.dimension, this.predicateFactory);
    }

    @Override
    public VectorValueMatcher makeVectorMatcher(VectorColumnSelectorFactory factory) {
        return DimensionHandlerUtils.makeVectorProcessor(this.dimension, VectorValueMatcherColumnStrategizer.instance(), factory).makeMatcher(this.predicateFactory);
    }

    @Override
    public boolean canVectorizeMatcher() {
        return true;
    }

    @Override
    public Set<String> getRequiredColumns() {
        return ImmutableSet.of(this.dimension);
    }

    @Override
    public boolean supportsBitmapIndex(BitmapIndexSelector selector) {
        return selector.getBitmapIndex(this.dimension) != null;
    }

    @Override
    public boolean shouldUseBitmapIndex(BitmapIndexSelector selector) {
        return Filters.shouldUseBitmapIndex(this, selector, this.filterTuning);
    }

    @Override
    public boolean supportsSelectivityEstimation(ColumnSelector columnSelector, BitmapIndexSelector indexSelector) {
        return Filters.supportsSelectivityEstimation(this, this.dimension, columnSelector, indexSelector);
    }

    @Override
    public double estimateSelectivity(BitmapIndexSelector indexSelector) {
        return Filters.estimateSelectivity(this.dimension, indexSelector, this.predicateFactory.makeStringPredicate());
    }

    public String toString() {
        if (this.extractionFn != null) {
            return StringUtils.format("%s(%s) = %s", this.extractionFn, this.dimension, this.basePredicateString);
        }
        return StringUtils.format("%s = %s", this.dimension, this.basePredicateString);
    }
}

