/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.filter;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.org.apache.druid.query.BitmapResultFactory;
import org.apache.hive.druid.org.apache.druid.query.ColumnSelectorPlus;
import org.apache.hive.druid.org.apache.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.org.apache.druid.query.filter.BitmapIndexSelector;
import org.apache.hive.druid.org.apache.druid.query.filter.Filter;
import org.apache.hive.druid.org.apache.druid.query.filter.ValueGetter;
import org.apache.hive.druid.org.apache.druid.query.filter.ValueMatcher;
import org.apache.hive.druid.org.apache.druid.query.filter.ValueMatcherColumnSelectorStrategy;
import org.apache.hive.druid.org.apache.druid.query.filter.ValueMatcherColumnSelectorStrategyFactory;
import org.apache.hive.druid.org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.hive.druid.org.apache.druid.segment.ColumnSelector;
import org.apache.hive.druid.org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.hive.druid.org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.hive.druid.org.apache.druid.segment.filter.BooleanValueMatcher;

public class ColumnComparisonFilter
implements Filter {
    private final List<DimensionSpec> dimensions;

    public ColumnComparisonFilter(List<DimensionSpec> dimensions) {
        this.dimensions = Preconditions.checkNotNull(dimensions, "dimensions");
    }

    @Override
    public <T> T getBitmapResult(BitmapIndexSelector selector, BitmapResultFactory<T> bitmapResultFactory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ValueMatcher makeMatcher(ColumnSelectorFactory factory) {
        ValueGetter[] valueGetters = new ValueGetter[this.dimensions.size()];
        for (int i = 0; i < this.dimensions.size(); ++i) {
            ColumnSelectorPlus<ValueMatcherColumnSelectorStrategy> selector = DimensionHandlerUtils.createColumnSelectorPlus(ValueMatcherColumnSelectorStrategyFactory.instance(), this.dimensions.get(i), factory);
            valueGetters[i] = selector.getColumnSelectorStrategy().makeValueGetter(selector.getSelector());
        }
        return ColumnComparisonFilter.makeValueMatcher(valueGetters);
    }

    public static ValueMatcher makeValueMatcher(final ValueGetter[] valueGetters) {
        if (valueGetters.length == 0) {
            return BooleanValueMatcher.of(true);
        }
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                String[][] values = new String[valueGetters.length][];
                for (int i = 0; i < valueGetters.length; ++i) {
                    values[i] = valueGetters[i].get();
                    for (int j = 0; j < i; ++j) {
                        if (ColumnComparisonFilter.overlap(values[i], values[j])) continue;
                        return false;
                    }
                }
                return true;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("oneValueGetter", valueGetters[0]);
            }
        };
    }

    public static boolean overlap(@Nullable String[] as, @Nullable String[] bs) {
        if (as == null || bs == null) {
            return as == null && bs == null;
        }
        if (as.length == 0 && bs.length == 0) {
            return true;
        }
        for (String a : as) {
            for (String b : bs) {
                if (!Objects.equals(a, b)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsBitmapIndex(BitmapIndexSelector selector) {
        return false;
    }

    @Override
    public boolean shouldUseBitmapIndex(BitmapIndexSelector selector) {
        return false;
    }

    @Override
    public boolean supportsSelectivityEstimation(ColumnSelector columnSelector, BitmapIndexSelector indexSelector) {
        return false;
    }

    @Override
    public Set<String> getRequiredColumns() {
        return this.dimensions.stream().map(DimensionSpec::getDimension).collect(Collectors.toSet());
    }

    @Override
    public double estimateSelectivity(BitmapIndexSelector indexSelector) {
        throw new UnsupportedOperationException();
    }
}

