/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.column;

import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.org.apache.druid.segment.column.BaseColumn;
import org.apache.hive.druid.org.apache.druid.segment.column.BitmapIndex;
import org.apache.hive.druid.org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.hive.druid.org.apache.druid.segment.column.ColumnHolder;
import org.apache.hive.druid.org.apache.druid.segment.column.NumericColumn;
import org.apache.hive.druid.org.apache.druid.segment.column.SpatialIndex;
import org.apache.hive.druid.org.apache.druid.segment.selector.settable.SettableColumnValueSelector;

class SimpleColumnHolder
implements ColumnHolder {
    private final ColumnCapabilities capabilities;
    private final Supplier<? extends BaseColumn> columnSupplier;
    @Nullable
    private final Supplier<BitmapIndex> bitmapIndex;
    @Nullable
    private final Supplier<SpatialIndex> spatialIndex;

    SimpleColumnHolder(ColumnCapabilities capabilities, Supplier<? extends BaseColumn> columnSupplier, @Nullable Supplier<BitmapIndex> bitmapIndex, @Nullable Supplier<SpatialIndex> spatialIndex) {
        this.capabilities = capabilities;
        this.columnSupplier = columnSupplier;
        this.bitmapIndex = bitmapIndex;
        this.spatialIndex = spatialIndex;
    }

    @Override
    public ColumnCapabilities getCapabilities() {
        return this.capabilities;
    }

    @Override
    public int getLength() {
        try (NumericColumn column = (NumericColumn)this.columnSupplier.get();){
            int n = column.length();
            return n;
        }
    }

    @Override
    public BaseColumn getColumn() {
        return this.columnSupplier.get();
    }

    @Override
    @Nullable
    public BitmapIndex getBitmapIndex() {
        return this.bitmapIndex == null ? null : this.bitmapIndex.get();
    }

    @Override
    @Nullable
    public SpatialIndex getSpatialIndex() {
        return this.spatialIndex == null ? null : this.spatialIndex.get();
    }

    @Override
    public SettableColumnValueSelector makeNewSettableColumnValueSelector() {
        return this.getCapabilities().getType().makeNewSettableColumnValueSelector();
    }
}

