/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment;

import java.util.List;
import java.util.function.Predicate;
import org.apache.hive.druid.org.apache.druid.segment.ForwardingRowIterator;
import org.apache.hive.druid.org.apache.druid.segment.IndexableAdapter;
import org.apache.hive.druid.org.apache.druid.segment.Metadata;
import org.apache.hive.druid.org.apache.druid.segment.QueryableIndexIndexableAdapter;
import org.apache.hive.druid.org.apache.druid.segment.RowPointer;
import org.apache.hive.druid.org.apache.druid.segment.TransformableRowIterator;
import org.apache.hive.druid.org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.hive.druid.org.apache.druid.segment.data.BitmapValues;
import org.apache.hive.druid.org.apache.druid.segment.data.CloseableIndexed;
import org.joda.time.Interval;

public class RowFilteringIndexAdapter
implements IndexableAdapter {
    private final QueryableIndexIndexableAdapter baseAdapter;
    private final Predicate<RowPointer> filter;

    public RowFilteringIndexAdapter(QueryableIndexIndexableAdapter baseAdapter, Predicate<RowPointer> filter) {
        this.baseAdapter = baseAdapter;
        this.filter = filter;
    }

    @Override
    public Interval getDataInterval() {
        return this.baseAdapter.getDataInterval();
    }

    @Override
    public int getNumRows() {
        return this.baseAdapter.getNumRows();
    }

    @Override
    public List<String> getDimensionNames() {
        return this.baseAdapter.getDimensionNames();
    }

    @Override
    public List<String> getMetricNames() {
        return this.baseAdapter.getMetricNames();
    }

    @Override
    public <T extends Comparable<? super T>> CloseableIndexed<T> getDimValueLookup(String dimension) {
        return this.baseAdapter.getDimValueLookup(dimension);
    }

    @Override
    public TransformableRowIterator getRows() {
        final QueryableIndexIndexableAdapter.RowIteratorImpl baseRowIterator = this.baseAdapter.getRows();
        return new ForwardingRowIterator(baseRowIterator){
            private boolean memoizedOffset;
            {
                super(baseIterator);
                this.memoizedOffset = false;
            }

            @Override
            public boolean moveToNext() {
                while (baseRowIterator.moveToNext()) {
                    if (!RowFilteringIndexAdapter.this.filter.test(baseRowIterator.getPointer())) continue;
                    baseRowIterator.memoizeOffset();
                    this.memoizedOffset = true;
                    return true;
                }
                if (this.memoizedOffset) {
                    baseRowIterator.resetToMemoizedOffset();
                }
                return false;
            }
        };
    }

    @Override
    public String getMetricType(String metric) {
        return this.baseAdapter.getMetricType(metric);
    }

    @Override
    public ColumnCapabilities getCapabilities(String column) {
        return this.baseAdapter.getCapabilities(column);
    }

    @Override
    public BitmapValues getBitmapValues(String dimension, int dictId) {
        return this.baseAdapter.getBitmapValues(dimension, dictId);
    }

    @Override
    public Metadata getMetadata() {
        return this.baseAdapter.getMetadata();
    }
}

