/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.topn.types;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.hive.druid.org.apache.druid.query.aggregation.Aggregator;
import org.apache.hive.druid.org.apache.druid.query.topn.BaseTopNAlgorithm;
import org.apache.hive.druid.org.apache.druid.query.topn.TopNQuery;
import org.apache.hive.druid.org.apache.druid.query.topn.types.NullableNumericTopNColumnAggregatesProcessor;
import org.apache.hive.druid.org.apache.druid.segment.BaseFloatColumnValueSelector;
import org.apache.hive.druid.org.apache.druid.segment.Cursor;

public class FloatTopNColumnAggregatesProcessor
extends NullableNumericTopNColumnAggregatesProcessor<BaseFloatColumnValueSelector> {
    private Int2ObjectMap<Aggregator[]> aggregatesStore;

    protected FloatTopNColumnAggregatesProcessor(Function<Object, Comparable<?>> converter) {
        super(converter);
    }

    @Override
    Aggregator[] getValueAggregators(TopNQuery query, BaseFloatColumnValueSelector selector, Cursor cursor) {
        int key = Float.floatToIntBits(selector.getFloat());
        return this.aggregatesStore.computeIfAbsent(key, k -> BaseTopNAlgorithm.makeAggregators(cursor, query.getAggregatorSpecs()));
    }

    @Override
    public void initAggregateStore() {
        this.nullValueAggregates = null;
        this.aggregatesStore = new Int2ObjectOpenHashMap<Aggregator[]>();
    }

    @Override
    Map<?, Aggregator[]> getAggregatesStore() {
        return this.aggregatesStore;
    }

    @Override
    Comparable<?> convertAggregatorStoreKeyToColumnValue(Object aggregatorStoreKey) {
        return (Comparable)this.converter.apply(Float.valueOf(Float.intBitsToFloat((Integer)aggregatorStoreKey)));
    }
}

