/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.lookup;

import com.google.inject.Binder;
import com.google.inject.Provides;
import java.util.List;
import org.apache.curator.utils.ZKPaths;
import org.apache.hive.druid.com.fasterxml.jackson.databind.Module;
import org.apache.hive.druid.com.fasterxml.jackson.databind.jsontype.NamedType;
import org.apache.hive.druid.com.fasterxml.jackson.databind.module.SimpleModule;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.org.apache.druid.discovery.LookupNodeService;
import org.apache.hive.druid.org.apache.druid.guice.ExpressionModule;
import org.apache.hive.druid.org.apache.druid.guice.Jerseys;
import org.apache.hive.druid.org.apache.druid.guice.JsonConfigProvider;
import org.apache.hive.druid.org.apache.druid.guice.LazySingleton;
import org.apache.hive.druid.org.apache.druid.guice.LifecycleModule;
import org.apache.hive.druid.org.apache.druid.guice.ManageLifecycle;
import org.apache.hive.druid.org.apache.druid.initialization.DruidModule;
import org.apache.hive.druid.org.apache.druid.query.dimension.LookupDimensionSpec;
import org.apache.hive.druid.org.apache.druid.query.expression.LookupExprMacro;
import org.apache.hive.druid.org.apache.druid.query.lookup.LookupConfig;
import org.apache.hive.druid.org.apache.druid.query.lookup.LookupExtractorFactoryContainerProvider;
import org.apache.hive.druid.org.apache.druid.query.lookup.LookupIntrospectionResource;
import org.apache.hive.druid.org.apache.druid.query.lookup.LookupListeningAnnouncerConfig;
import org.apache.hive.druid.org.apache.druid.query.lookup.LookupListeningResource;
import org.apache.hive.druid.org.apache.druid.query.lookup.LookupReferencesManager;
import org.apache.hive.druid.org.apache.druid.query.lookup.LookupResourceListenerAnnouncer;
import org.apache.hive.druid.org.apache.druid.query.lookup.MapLookupExtractorFactory;
import org.apache.hive.druid.org.apache.druid.query.lookup.RegisteredLookupExtractionFn;
import org.apache.hive.druid.org.apache.druid.server.initialization.jetty.JettyBindings;

public class LookupModule
implements DruidModule {
    static final String PROPERTY_BASE = "druid.lookup";
    public static final String FAILED_UPDATES_KEY = "failedUpdates";
    public static final int LOOKUP_LISTENER_QOS_MAX_REQUESTS = 2;

    public static String getTierListenerPath(String tier) {
        return ZKPaths.makePath((String)"lookups", (String)tier);
    }

    @Override
    public List<? extends Module> getJacksonModules() {
        return ImmutableList.of(new SimpleModule("DruidLookupModule").registerSubtypes(MapLookupExtractorFactory.class), new SimpleModule().registerSubtypes(new NamedType(LookupDimensionSpec.class, "lookup"), new NamedType(RegisteredLookupExtractionFn.class, "registeredLookup")));
    }

    public void configure(Binder binder) {
        JsonConfigProvider.bind(binder, PROPERTY_BASE, LookupConfig.class);
        binder.bind(LookupExtractorFactoryContainerProvider.class).to(LookupReferencesManager.class);
        LifecycleModule.register(binder, LookupReferencesManager.class);
        JsonConfigProvider.bind(binder, PROPERTY_BASE, LookupListeningAnnouncerConfig.class);
        Jerseys.addResource(binder, LookupListeningResource.class);
        Jerseys.addResource(binder, LookupIntrospectionResource.class);
        ExpressionModule.addExprMacro(binder, LookupExprMacro.class);
        LifecycleModule.register(binder, LookupResourceListenerAnnouncer.class);
        binder.bind(LookupResourceListenerAnnouncer.class).in(ManageLifecycle.class);
        JettyBindings.addQosFilter(binder, "/druid/listen/v1/lookups", 2);
    }

    @Provides
    @LazySingleton
    public LookupNodeService getLookupNodeService(LookupListeningAnnouncerConfig lookupListeningAnnouncerConfig) {
        return new LookupNodeService(lookupListeningAnnouncerConfig.getLookupTier());
    }
}

