/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.groupby.epinephelinae.vector;

import java.nio.ByteBuffer;
import org.apache.hive.druid.org.apache.druid.query.groupby.ResultRow;
import org.apache.hive.druid.org.apache.druid.query.groupby.epinephelinae.vector.GroupByVectorColumnSelector;
import org.apache.hive.druid.org.apache.druid.segment.vector.VectorValueSelector;

public class DoubleGroupByVectorColumnSelector
implements GroupByVectorColumnSelector {
    private final VectorValueSelector selector;

    DoubleGroupByVectorColumnSelector(VectorValueSelector selector) {
        this.selector = selector;
    }

    @Override
    public int getGroupingKeySize() {
        return 2;
    }

    @Override
    public void writeKeys(int[] keySpace, int keySize, int keyOffset, int startRow, int endRow) {
        double[] vector = this.selector.getDoubleVector();
        int i = startRow;
        int j = keyOffset;
        while (i < endRow) {
            long longValue = Double.doubleToLongBits(vector[i]);
            keySpace[j] = (int)(longValue >>> 32);
            keySpace[j + 1] = (int)(longValue & 0xFFFFFFFFL);
            ++i;
            j += keySize;
        }
    }

    @Override
    public void writeKeyToResultRow(ByteBuffer keyBuffer, int keyOffset, ResultRow resultRow, int resultRowPosition) {
        double value = keyBuffer.getDouble(keyOffset * 4);
        resultRow.set(resultRowPosition, value);
    }
}

