/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.filter;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.com.google.common.collect.RangeSet;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.org.apache.druid.query.filter.DimFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.Filter;
import org.apache.hive.druid.org.apache.druid.query.filter.FilterTuning;
import org.apache.hive.druid.org.apache.druid.segment.filter.RegexFilter;

public class RegexDimFilter
implements DimFilter {
    private final String dimension;
    private final String pattern;
    @Nullable
    private final ExtractionFn extractionFn;
    @Nullable
    private final FilterTuning filterTuning;
    private final Pattern compiledPattern;

    @JsonCreator
    public RegexDimFilter(@JsonProperty(value="dimension") String dimension, @JsonProperty(value="pattern") String pattern, @JsonProperty(value="extractionFn") @Nullable ExtractionFn extractionFn, @JsonProperty(value="filterTuning") @Nullable FilterTuning filterTuning) {
        Preconditions.checkArgument(dimension != null, "dimension must not be null");
        Preconditions.checkArgument(pattern != null, "pattern must not be null");
        this.dimension = dimension;
        this.pattern = pattern;
        this.extractionFn = extractionFn;
        this.compiledPattern = Pattern.compile(pattern);
        this.filterTuning = filterTuning;
    }

    @VisibleForTesting
    public RegexDimFilter(String dimension, String pattern, @Nullable ExtractionFn extractionFn) {
        this(dimension, pattern, extractionFn, null);
    }

    @JsonProperty
    public String getDimension() {
        return this.dimension;
    }

    @JsonProperty
    public String getPattern() {
        return this.pattern;
    }

    @Nullable
    @JsonProperty
    public ExtractionFn getExtractionFn() {
        return this.extractionFn;
    }

    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty
    public FilterTuning getFilterTuning() {
        return this.filterTuning;
    }

    @Override
    public byte[] getCacheKey() {
        byte[] dimensionBytes = StringUtils.toUtf8(this.dimension);
        byte[] patternBytes = StringUtils.toUtf8(this.pattern);
        byte[] extractionFnBytes = this.extractionFn == null ? new byte[]{} : this.extractionFn.getCacheKey();
        return ByteBuffer.allocate(3 + dimensionBytes.length + patternBytes.length + extractionFnBytes.length).put((byte)5).put(dimensionBytes).put((byte)-1).put(patternBytes).put((byte)-1).put(extractionFnBytes).array();
    }

    @Override
    public DimFilter optimize() {
        return this;
    }

    @Override
    public Filter toFilter() {
        return new RegexFilter(this.dimension, this.compiledPattern, this.extractionFn, this.filterTuning);
    }

    @Override
    public RangeSet<String> getDimensionRangeSet(String dimension) {
        return null;
    }

    @Override
    public Set<String> getRequiredColumns() {
        return ImmutableSet.of(this.dimension);
    }

    public String toString() {
        return "RegexDimFilter{dimension='" + this.dimension + '\'' + ", pattern='" + this.pattern + '\'' + ", extractionFn='" + this.extractionFn + '\'' + ", filterTuning=" + this.filterTuning + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegexDimFilter that = (RegexDimFilter)o;
        return this.dimension.equals(that.dimension) && this.pattern.equals(that.pattern) && Objects.equals(this.extractionFn, that.extractionFn) && Objects.equals(this.filterTuning, that.filterTuning);
    }

    public int hashCode() {
        return Objects.hash(this.dimension, this.pattern, this.extractionFn, this.filterTuning);
    }
}

