/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.filter;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.base.Suppliers;
import org.apache.hive.druid.com.google.common.collect.BoundType;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.com.google.common.collect.Range;
import org.apache.hive.druid.com.google.common.collect.RangeSet;
import org.apache.hive.druid.com.google.common.collect.TreeRangeSet;
import org.apache.hive.druid.com.google.common.primitives.Doubles;
import org.apache.hive.druid.com.google.common.primitives.Floats;
import org.apache.hive.druid.org.apache.druid.common.guava.GuavaUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.org.apache.druid.query.filter.DimFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.DruidDoublePredicate;
import org.apache.hive.druid.org.apache.druid.query.filter.DruidFloatPredicate;
import org.apache.hive.druid.org.apache.druid.query.filter.DruidLongPredicate;
import org.apache.hive.druid.org.apache.druid.query.filter.Filter;
import org.apache.hive.druid.org.apache.druid.query.filter.FilterTuning;
import org.apache.hive.druid.org.apache.druid.query.ordering.StringComparator;
import org.apache.hive.druid.org.apache.druid.query.ordering.StringComparators;
import org.apache.hive.druid.org.apache.druid.segment.filter.BoundFilter;

public class BoundDimFilter
implements DimFilter {
    private final String dimension;
    @Nullable
    private final String upper;
    @Nullable
    private final String lower;
    private final boolean lowerStrict;
    private final boolean upperStrict;
    @Nullable
    private final ExtractionFn extractionFn;
    private final StringComparator ordering;
    private final Supplier<DruidLongPredicate> longPredicateSupplier;
    private final Supplier<DruidFloatPredicate> floatPredicateSupplier;
    private final Supplier<DruidDoublePredicate> doublePredicateSupplier;
    @Nullable
    private final FilterTuning filterTuning;

    @JsonCreator
    public BoundDimFilter(@JsonProperty(value="dimension") String dimension, @JsonProperty(value="lower") @Nullable String lower, @JsonProperty(value="upper") @Nullable String upper, @JsonProperty(value="lowerStrict") @Nullable Boolean lowerStrict, @JsonProperty(value="upperStrict") @Nullable Boolean upperStrict, @Deprecated @JsonProperty(value="alphaNumeric") @Nullable Boolean alphaNumeric, @JsonProperty(value="extractionFn") @Nullable ExtractionFn extractionFn, @JsonProperty(value="ordering") @Nullable StringComparator ordering, @JsonProperty(value="filterTuning") @Nullable FilterTuning filterTuning) {
        this.dimension = Preconditions.checkNotNull(dimension, "dimension can not be null");
        Preconditions.checkState(lower != null || upper != null, "lower and upper can not be null at the same time");
        this.upper = upper;
        this.lower = lower;
        this.lowerStrict = lowerStrict == null ? false : lowerStrict;
        boolean bl = this.upperStrict = upperStrict == null ? false : upperStrict;
        if (ordering == null) {
            this.ordering = alphaNumeric == null || !alphaNumeric.booleanValue() ? StringComparators.LEXICOGRAPHIC : StringComparators.ALPHANUMERIC;
        } else {
            this.ordering = ordering;
            if (alphaNumeric != null) {
                boolean orderingIsAlphanumeric = this.ordering.equals(StringComparators.ALPHANUMERIC);
                Preconditions.checkState(alphaNumeric == orderingIsAlphanumeric, "mismatch between alphanumeric and ordering property");
            }
        }
        this.extractionFn = extractionFn;
        this.longPredicateSupplier = this.makeLongPredicateSupplier();
        this.floatPredicateSupplier = this.makeFloatPredicateSupplier();
        this.doublePredicateSupplier = this.makeDoublePredicateSupplier();
        this.filterTuning = filterTuning;
    }

    @VisibleForTesting
    public BoundDimFilter(String dimension, @Nullable String lower, @Nullable String upper, @Nullable Boolean lowerStrict, @Nullable Boolean upperStrict, @Nullable Boolean alphaNumeric, @Nullable ExtractionFn extractionFn, @Nullable StringComparator ordering) {
        this(dimension, lower, upper, lowerStrict, upperStrict, alphaNumeric, extractionFn, ordering, null);
    }

    @JsonProperty
    public String getDimension() {
        return this.dimension;
    }

    @Nullable
    @JsonProperty
    public String getUpper() {
        return this.upper;
    }

    @Nullable
    @JsonProperty
    public String getLower() {
        return this.lower;
    }

    @JsonProperty
    public boolean isLowerStrict() {
        return this.lowerStrict;
    }

    @JsonProperty
    public boolean isUpperStrict() {
        return this.upperStrict;
    }

    public boolean hasLowerBound() {
        return this.lower != null;
    }

    public boolean hasUpperBound() {
        return this.upper != null;
    }

    @Nullable
    @JsonProperty
    public ExtractionFn getExtractionFn() {
        return this.extractionFn;
    }

    @JsonProperty
    public StringComparator getOrdering() {
        return this.ordering;
    }

    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty
    public FilterTuning getFilterTuning() {
        return this.filterTuning;
    }

    public Supplier<DruidLongPredicate> getLongPredicateSupplier() {
        return this.longPredicateSupplier;
    }

    public Supplier<DruidFloatPredicate> getFloatPredicateSupplier() {
        return this.floatPredicateSupplier;
    }

    public Supplier<DruidDoublePredicate> getDoublePredicateSupplier() {
        return this.doublePredicateSupplier;
    }

    @Override
    public byte[] getCacheKey() {
        byte[] dimensionBytes = StringUtils.toUtf8(this.getDimension());
        byte[] lowerBytes = this.getLower() == null ? new byte[]{} : StringUtils.toUtf8(this.getLower());
        byte[] upperBytes = this.getUpper() == null ? new byte[]{} : StringUtils.toUtf8(this.getUpper());
        byte boundType = 1;
        if (this.getLower() == null) {
            boundType = 2;
        } else if (this.getUpper() == null) {
            boundType = 3;
        }
        byte lowerStrictByte = !this.isLowerStrict() ? (byte)0 : 1;
        byte upperStrictByte = !this.isUpperStrict() ? (byte)0 : 1;
        byte[] extractionFnBytes = this.extractionFn == null ? new byte[]{} : this.extractionFn.getCacheKey();
        byte[] orderingBytes = this.ordering.getCacheKey();
        ByteBuffer boundCacheBuffer = ByteBuffer.allocate(9 + dimensionBytes.length + upperBytes.length + lowerBytes.length + extractionFnBytes.length + orderingBytes.length);
        boundCacheBuffer.put((byte)10).put(boundType).put(upperStrictByte).put(lowerStrictByte).put((byte)-1).put(dimensionBytes).put((byte)-1).put(upperBytes).put((byte)-1).put(lowerBytes).put((byte)-1).put(extractionFnBytes).put((byte)-1).put(orderingBytes);
        return boundCacheBuffer.array();
    }

    @Override
    public DimFilter optimize() {
        return this;
    }

    @Override
    public Filter toFilter() {
        return new BoundFilter(this);
    }

    @Override
    public RangeSet<String> getDimensionRangeSet(String dimension) {
        if (!Objects.equals(this.getDimension(), dimension) || this.getExtractionFn() != null || !this.ordering.equals(StringComparators.LEXICOGRAPHIC)) {
            return null;
        }
        TreeRangeSet<String> retSet = TreeRangeSet.create();
        Range<String> range = this.getLower() == null ? (this.isUpperStrict() ? Range.lessThan(this.getUpper()) : Range.atMost(this.getUpper())) : (this.getUpper() == null ? (this.isLowerStrict() ? Range.greaterThan(this.getLower()) : Range.atLeast(this.getLower())) : Range.range(this.getLower(), this.isLowerStrict() ? BoundType.OPEN : BoundType.CLOSED, this.getUpper(), this.isUpperStrict() ? BoundType.OPEN : BoundType.CLOSED));
        retSet.add(range);
        return retSet;
    }

    @Override
    public Set<String> getRequiredColumns() {
        return ImmutableSet.of(this.dimension);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoundDimFilter that = (BoundDimFilter)o;
        return this.lowerStrict == that.lowerStrict && this.upperStrict == that.upperStrict && this.dimension.equals(that.dimension) && Objects.equals(this.upper, that.upper) && Objects.equals(this.lower, that.lower) && Objects.equals(this.extractionFn, that.extractionFn) && Objects.equals(this.ordering, that.ordering) && Objects.equals(this.filterTuning, that.filterTuning);
    }

    public int hashCode() {
        return Objects.hash(this.dimension, this.upper, this.lower, this.lowerStrict, this.upperStrict, this.extractionFn, this.ordering, this.filterTuning);
    }

    public String toString() {
        DimFilter.DimFilterToStringBuilder builder = new DimFilter.DimFilterToStringBuilder();
        if (this.lower != null) {
            builder.append(this.lower);
            if (this.lowerStrict) {
                builder.append(" < ");
            } else {
                builder.append(" <= ");
            }
        }
        builder.appendDimension(this.dimension, this.extractionFn);
        if (!this.ordering.equals(StringComparators.LEXICOGRAPHIC)) {
            builder.append(StringUtils.format(" as %s", this.ordering.toString()));
        }
        if (this.upper != null) {
            if (this.upperStrict) {
                builder.append(" < ");
            } else {
                builder.append(" <= ");
            }
            builder.append(this.upper);
        }
        return builder.appendFilterTuning(this.filterTuning).build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DruidLongPredicate createLongPredicate() {
        long upperLongBound;
        boolean hasUpperLongBound;
        long lowerLongBound;
        boolean hasLowerLongBound;
        boolean matchesNothing;
        block12: {
            block15: {
                Long upperLong;
                block16: {
                    block11: {
                        block13: {
                            Long lowerLong;
                            block14: {
                                matchesNothing = false;
                                if (!this.hasLowerBound()) break block13;
                                lowerLong = GuavaUtils.tryParseLong(this.lower);
                                if (lowerLong != null) break block14;
                                BigDecimal lowerBigDecimal = this.getBigDecimalLowerBoundFromFloatString(this.lower);
                                if (lowerBigDecimal == null) {
                                    hasLowerLongBound = false;
                                    lowerLongBound = 0L;
                                    break block11;
                                } else {
                                    try {
                                        lowerLongBound = lowerBigDecimal.longValueExact();
                                        hasLowerLongBound = true;
                                    }
                                    catch (ArithmeticException ae) {
                                        hasLowerLongBound = false;
                                        lowerLongBound = 0L;
                                        if (lowerBigDecimal.compareTo(BigDecimal.ZERO) > 0) {
                                            matchesNothing = true;
                                        }
                                        break block11;
                                    }
                                }
                            }
                            hasLowerLongBound = true;
                            lowerLongBound = lowerLong;
                            break block11;
                        }
                        hasLowerLongBound = false;
                        lowerLongBound = 0L;
                    }
                    if (!this.hasUpperBound()) break block15;
                    upperLong = GuavaUtils.tryParseLong(this.upper);
                    if (upperLong != null) break block16;
                    BigDecimal upperBigDecimal = this.getBigDecimalUpperBoundFromFloatString(this.upper);
                    if (upperBigDecimal == null) {
                        matchesNothing = true;
                        hasUpperLongBound = false;
                        upperLongBound = 0L;
                        break block12;
                    } else {
                        try {
                            upperLongBound = upperBigDecimal.longValueExact();
                            hasUpperLongBound = true;
                        }
                        catch (ArithmeticException ae) {
                            hasUpperLongBound = false;
                            upperLongBound = 0L;
                            if (upperBigDecimal.compareTo(BigDecimal.ZERO) < 0) {
                                matchesNothing = true;
                            }
                            break block12;
                        }
                    }
                }
                hasUpperLongBound = true;
                upperLongBound = upperLong;
                break block12;
            }
            hasUpperLongBound = false;
            upperLongBound = 0L;
        }
        if (matchesNothing) {
            return DruidLongPredicate.ALWAYS_FALSE;
        }
        return BoundDimFilter.makeLongPredicateFromBounds(hasLowerLongBound, hasUpperLongBound, this.lowerStrict, this.upperStrict, lowerLongBound, upperLongBound);
    }

    private Supplier<DruidLongPredicate> makeLongPredicateSupplier() {
        Supplier<DruidLongPredicate> longPredicate = () -> this.createLongPredicate();
        return Suppliers.memoize(longPredicate);
    }

    @Nullable
    private BigDecimal getBigDecimalLowerBoundFromFloatString(String floatStr) {
        BigDecimal convertedBD;
        try {
            convertedBD = new BigDecimal(floatStr);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        if (this.lowerStrict) {
            return convertedBD.setScale(0, RoundingMode.FLOOR);
        }
        return convertedBD.setScale(0, RoundingMode.CEILING);
    }

    @Nullable
    private BigDecimal getBigDecimalUpperBoundFromFloatString(String floatStr) {
        BigDecimal convertedBD;
        try {
            convertedBD = new BigDecimal(floatStr);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        if (this.upperStrict) {
            return convertedBD.setScale(0, RoundingMode.CEILING);
        }
        return convertedBD.setScale(0, RoundingMode.FLOOR);
    }

    private DruidFloatPredicate createDruidFloatPredicate() {
        float upperFloatBound;
        boolean hasUpperFloatBound;
        float lowerFloatBound;
        boolean hasLowerFloatBound;
        boolean matchesNothing = false;
        if (this.hasLowerBound()) {
            Float lowerFloat = Floats.tryParse(this.lower);
            if (lowerFloat == null) {
                hasLowerFloatBound = false;
                lowerFloatBound = 0.0f;
            } else {
                hasLowerFloatBound = true;
                lowerFloatBound = lowerFloat.floatValue();
            }
        } else {
            hasLowerFloatBound = false;
            lowerFloatBound = 0.0f;
        }
        if (this.hasUpperBound()) {
            Float upperFloat = Floats.tryParse(this.upper);
            if (upperFloat == null) {
                matchesNothing = true;
                hasUpperFloatBound = false;
                upperFloatBound = 0.0f;
            } else {
                hasUpperFloatBound = true;
                upperFloatBound = upperFloat.floatValue();
            }
        } else {
            hasUpperFloatBound = false;
            upperFloatBound = 0.0f;
        }
        if (matchesNothing) {
            return DruidFloatPredicate.ALWAYS_FALSE;
        }
        return input -> {
            DruidDoublePredicate druidDoublePredicate = BoundDimFilter.makeDoublePredicateFromBounds(hasLowerFloatBound, hasUpperFloatBound, this.lowerStrict, this.upperStrict, lowerFloatBound, upperFloatBound);
            return druidDoublePredicate.applyDouble(input);
        };
    }

    private Supplier<DruidFloatPredicate> makeFloatPredicateSupplier() {
        Supplier<DruidFloatPredicate> floatPredicate = () -> this.createDruidFloatPredicate();
        return Suppliers.memoize(floatPredicate);
    }

    private DruidDoublePredicate createDruidDoublePredicate() {
        double upperDoubleBound;
        boolean hasUpperBound;
        double lowerDoubleBound;
        boolean hasLowerBound;
        boolean matchesNothing = false;
        if (this.hasLowerBound()) {
            Double lowerDouble = Doubles.tryParse(this.lower);
            if (lowerDouble == null) {
                hasLowerBound = false;
                lowerDoubleBound = 0.0;
            } else {
                hasLowerBound = true;
                lowerDoubleBound = lowerDouble;
            }
        } else {
            hasLowerBound = false;
            lowerDoubleBound = 0.0;
        }
        if (this.hasUpperBound()) {
            Double upperDouble = Doubles.tryParse(this.upper);
            if (upperDouble == null) {
                matchesNothing = true;
                hasUpperBound = false;
                upperDoubleBound = 0.0;
            } else {
                hasUpperBound = true;
                upperDoubleBound = upperDouble;
            }
        } else {
            hasUpperBound = false;
            upperDoubleBound = 0.0;
        }
        if (matchesNothing) {
            return DruidDoublePredicate.ALWAYS_FALSE;
        }
        return BoundDimFilter.makeDoublePredicateFromBounds(hasLowerBound, hasUpperBound, this.lowerStrict, this.upperStrict, lowerDoubleBound, upperDoubleBound);
    }

    private Supplier<DruidDoublePredicate> makeDoublePredicateSupplier() {
        Supplier<DruidDoublePredicate> doublePredicate = () -> this.createDruidDoublePredicate();
        return Suppliers.memoize(doublePredicate);
    }

    private static DruidLongPredicate makeLongPredicateFromBounds(boolean hasLowerLongBound, boolean hasUpperLongBound, boolean lowerStrict, boolean upperStrict, final long lowerLongBound, final long upperLongBound) {
        if (hasLowerLongBound && hasUpperLongBound) {
            if (upperStrict && lowerStrict) {
                return new DruidLongPredicate(){

                    @Override
                    public boolean applyLong(long input) {
                        int lowerComparing = Long.compare(input, lowerLongBound);
                        int upperComparing = Long.compare(upperLongBound, input);
                        return lowerComparing > 0 && upperComparing > 0;
                    }
                };
            }
            if (lowerStrict) {
                return new DruidLongPredicate(){

                    @Override
                    public boolean applyLong(long input) {
                        int lowerComparing = Long.compare(input, lowerLongBound);
                        int upperComparing = Long.compare(upperLongBound, input);
                        return lowerComparing > 0 && upperComparing >= 0;
                    }
                };
            }
            if (upperStrict) {
                return new DruidLongPredicate(){

                    @Override
                    public boolean applyLong(long input) {
                        int lowerComparing = Long.compare(input, lowerLongBound);
                        int upperComparing = Long.compare(upperLongBound, input);
                        return lowerComparing >= 0 && upperComparing > 0;
                    }
                };
            }
            return new DruidLongPredicate(){

                @Override
                public boolean applyLong(long input) {
                    int lowerComparing = Long.compare(input, lowerLongBound);
                    int upperComparing = Long.compare(upperLongBound, input);
                    return lowerComparing >= 0 && upperComparing >= 0;
                }
            };
        }
        if (hasUpperLongBound) {
            if (upperStrict) {
                return new DruidLongPredicate(){

                    @Override
                    public boolean applyLong(long input) {
                        int upperComparing = Long.compare(upperLongBound, input);
                        return upperComparing > 0;
                    }
                };
            }
            return new DruidLongPredicate(){

                @Override
                public boolean applyLong(long input) {
                    int upperComparing = Long.compare(upperLongBound, input);
                    return upperComparing >= 0;
                }
            };
        }
        if (hasLowerLongBound) {
            if (lowerStrict) {
                return new DruidLongPredicate(){

                    @Override
                    public boolean applyLong(long input) {
                        int lowerComparing = Long.compare(input, lowerLongBound);
                        return lowerComparing > 0;
                    }
                };
            }
            return new DruidLongPredicate(){

                @Override
                public boolean applyLong(long input) {
                    int lowerComparing = Long.compare(input, lowerLongBound);
                    return lowerComparing >= 0;
                }
            };
        }
        return DruidLongPredicate.ALWAYS_TRUE;
    }

    private static DruidDoublePredicate makeDoublePredicateFromBounds(boolean hasLowerDoubleBound, boolean hasUpperDoubleBound, boolean lowerStrict, boolean upperStrict, double lowerDoubleBound, double upperDoubleBound) {
        if (hasLowerDoubleBound && hasUpperDoubleBound) {
            if (upperStrict && lowerStrict) {
                return input -> {
                    int lowerComparing = Double.compare(input, lowerDoubleBound);
                    int upperComparing = Double.compare(upperDoubleBound, input);
                    return lowerComparing > 0 && upperComparing > 0;
                };
            }
            if (lowerStrict) {
                return input -> {
                    int lowerComparing = Double.compare(input, lowerDoubleBound);
                    int upperComparing = Double.compare(upperDoubleBound, input);
                    return lowerComparing > 0 && upperComparing >= 0;
                };
            }
            if (upperStrict) {
                return input -> {
                    int lowerComparing = Double.compare(input, lowerDoubleBound);
                    int upperComparing = Double.compare(upperDoubleBound, input);
                    return lowerComparing >= 0 && upperComparing > 0;
                };
            }
            return input -> {
                int lowerComparing = Double.compare(input, lowerDoubleBound);
                int upperComparing = Double.compare(upperDoubleBound, input);
                return lowerComparing >= 0 && upperComparing >= 0;
            };
        }
        if (hasUpperDoubleBound) {
            if (upperStrict) {
                return input -> {
                    int upperComparing = Double.compare(upperDoubleBound, input);
                    return upperComparing > 0;
                };
            }
            return input -> {
                int upperComparing = Double.compare(upperDoubleBound, input);
                return upperComparing >= 0;
            };
        }
        if (hasLowerDoubleBound) {
            if (lowerStrict) {
                return input -> {
                    int lowerComparing = Double.compare(input, lowerDoubleBound);
                    return lowerComparing > 0;
                };
            }
            return input -> {
                int lowerComparing = Double.compare(input, lowerDoubleBound);
                return lowerComparing >= 0;
            };
        }
        return DruidDoublePredicate.ALWAYS_TRUE;
    }
}

