/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.expression;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.net.InetAddresses;

class IPv4AddressExprUtils {
    private static final Pattern IPV4_PATTERN = Pattern.compile("^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$");

    IPv4AddressExprUtils() {
    }

    static boolean overflowsUnsignedInt(long value) {
        return value < 0L || 0xFFFFFFFFL < value;
    }

    static boolean isValidAddress(@Nullable String string) {
        return string != null && IPV4_PATTERN.matcher(string).matches();
    }

    @Nullable
    static Inet4Address parse(@Nullable String string) {
        InetAddress address;
        if (IPv4AddressExprUtils.isValidAddress(string) && (address = InetAddresses.forString(string)) instanceof Inet4Address) {
            return (Inet4Address)address;
        }
        return null;
    }

    static Inet4Address parse(int value) {
        return InetAddresses.fromInteger(value);
    }

    static String toString(Inet4Address address) {
        return address.getHostAddress();
    }

    static long toLong(Inet4Address address) {
        int value = InetAddresses.coerceToInteger(address);
        return Integer.toUnsignedLong(value);
    }
}

