/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.aggregation.last;

import org.apache.hive.druid.org.apache.druid.common.config.NullHandling;
import org.apache.hive.druid.org.apache.druid.query.aggregation.Aggregator;
import org.apache.hive.druid.org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.hive.druid.org.apache.druid.segment.BaseNullableColumnValueSelector;

public abstract class NumericLastAggregator<TSelector extends BaseNullableColumnValueSelector>
implements Aggregator {
    private final boolean useDefault = NullHandling.replaceWithDefault();
    private final BaseLongColumnValueSelector timeSelector;
    final TSelector valueSelector;
    long lastTime;
    boolean rhsNull;

    public NumericLastAggregator(BaseLongColumnValueSelector timeSelector, TSelector valueSelector) {
        this.timeSelector = timeSelector;
        this.valueSelector = valueSelector;
        this.lastTime = Long.MIN_VALUE;
        this.rhsNull = !this.useDefault;
    }

    @Override
    public void aggregate() {
        long time = this.timeSelector.getLong();
        if (time >= this.lastTime) {
            this.lastTime = time;
            if (this.useDefault || !this.valueSelector.isNull()) {
                this.setCurrentValue();
                this.rhsNull = false;
            } else {
                this.rhsNull = true;
            }
        }
    }

    @Override
    public void close() {
    }

    abstract void setCurrentValue();
}

