/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.aggregation.bloom.sql;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.hive.druid.org.apache.calcite.rel.core.AggregateCall;
import org.apache.hive.druid.org.apache.calcite.rel.core.Project;
import org.apache.hive.druid.org.apache.calcite.rex.RexBuilder;
import org.apache.hive.druid.org.apache.calcite.rex.RexLiteral;
import org.apache.hive.druid.org.apache.calcite.rex.RexNode;
import org.apache.hive.druid.org.apache.calcite.sql.SqlAggFunction;
import org.apache.hive.druid.org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.hive.druid.org.apache.calcite.sql.SqlKind;
import org.apache.hive.druid.org.apache.calcite.sql.type.OperandTypes;
import org.apache.hive.druid.org.apache.calcite.sql.type.ReturnTypes;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.bloom.BloomFilterAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.hive.druid.org.apache.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.org.apache.druid.query.dimension.ExtractionDimensionSpec;
import org.apache.hive.druid.org.apache.druid.segment.VirtualColumn;
import org.apache.hive.druid.org.apache.druid.segment.column.ValueType;
import org.apache.hive.druid.org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.hive.druid.org.apache.druid.sql.calcite.aggregation.Aggregation;
import org.apache.hive.druid.org.apache.druid.sql.calcite.aggregation.SqlAggregator;
import org.apache.hive.druid.org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.hive.druid.org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.hive.druid.org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.hive.druid.org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.hive.druid.org.apache.druid.sql.calcite.rel.VirtualColumnRegistry;
import org.apache.hive.druid.org.apache.druid.sql.calcite.table.RowSignature;

public class BloomFilterSqlAggregator
implements SqlAggregator {
    private static final SqlAggFunction FUNCTION_INSTANCE = new BloomFilterSqlAggFunction();
    private static final String NAME = "BLOOM_FILTER";

    public SqlAggFunction calciteFunction() {
        return FUNCTION_INSTANCE;
    }

    @Nullable
    public Aggregation toDruidAggregation(PlannerContext plannerContext, RowSignature rowSignature, VirtualColumnRegistry virtualColumnRegistry, RexBuilder rexBuilder, String name, AggregateCall aggregateCall, Project project, List<Aggregation> existingAggregations, boolean finalizeAggregations) {
        DimensionSpec spec;
        RexNode inputOperand = Expressions.fromFieldAccess((RowSignature)rowSignature, (Project)project, (int)aggregateCall.getArgList().get(0));
        DruidExpression input = Expressions.toDruidExpression((PlannerContext)plannerContext, (RowSignature)rowSignature, (RexNode)inputOperand);
        if (input == null) {
            return null;
        }
        String aggName = StringUtils.format("%s:agg", name);
        RexNode maxNumEntriesOperand = Expressions.fromFieldAccess((RowSignature)rowSignature, (Project)project, (int)aggregateCall.getArgList().get(1));
        if (!maxNumEntriesOperand.isA(SqlKind.LITERAL)) {
            return null;
        }
        int maxNumEntries = ((Number)((Object)RexLiteral.value(maxNumEntriesOperand))).intValue();
        for (Aggregation existing : existingAggregations) {
            for (AggregatorFactory factory : existing.getAggregatorFactories()) {
                if (!(factory instanceof BloomFilterAggregatorFactory)) continue;
                BloomFilterAggregatorFactory theFactory = (BloomFilterAggregatorFactory)factory;
                VirtualColumn virtualInput = existing.getVirtualColumns().stream().filter(virtualColumn -> virtualColumn.getOutputName().equals(theFactory.getField().getOutputName())).findFirst().orElse(null);
                boolean inputMatches = virtualInput == null ? (input.isDirectColumnAccess() ? input.getDirectColumn().equals(theFactory.getField().getDimension()) : input.getSimpleExtraction().getColumn().equals(theFactory.getField().getDimension()) && input.getSimpleExtraction().getExtractionFn().equals(theFactory.getField().getExtractionFn())) : ((ExpressionVirtualColumn)virtualInput).getExpression().equals(input.getExpression());
                boolean matches = inputMatches && theFactory.getMaxNumEntries() == maxNumEntries;
                if (!matches) continue;
                return Aggregation.create((AggregatorFactory)theFactory);
            }
        }
        ArrayList<VirtualColumn> virtualColumns = new ArrayList<VirtualColumn>();
        ValueType valueType = Calcites.getValueTypeForSqlTypeName((SqlTypeName)inputOperand.getType().getSqlTypeName());
        if (input.isDirectColumnAccess()) {
            spec = new DefaultDimensionSpec(input.getSimpleExtraction().getColumn(), StringUtils.format("%s:%s", name, input.getSimpleExtraction().getColumn()), valueType);
        } else if (input.isSimpleExtraction()) {
            spec = new ExtractionDimensionSpec(input.getSimpleExtraction().getColumn(), StringUtils.format("%s:%s", name, input.getSimpleExtraction().getColumn()), valueType, input.getSimpleExtraction().getExtractionFn());
        } else {
            VirtualColumn virtualColumn2 = virtualColumnRegistry.getOrCreateVirtualColumnForExpression(plannerContext, input, inputOperand.getType().getSqlTypeName());
            virtualColumns.add(virtualColumn2);
            spec = new DefaultDimensionSpec(virtualColumn2.getOutputName(), virtualColumn2.getOutputName());
        }
        BloomFilterAggregatorFactory aggregatorFactory = new BloomFilterAggregatorFactory(aggName, spec, maxNumEntries);
        return Aggregation.create(virtualColumns, (AggregatorFactory)aggregatorFactory);
    }

    private static class BloomFilterSqlAggFunction
    extends SqlAggFunction {
        private static final String SIGNATURE1 = "'BLOOM_FILTER(column, maxNumEntries)'\n";

        BloomFilterSqlAggFunction() {
            super(BloomFilterSqlAggregator.NAME, null, SqlKind.OTHER_FUNCTION, ReturnTypes.explicit(SqlTypeName.OTHER), null, OperandTypes.and(OperandTypes.sequence(SIGNATURE1, OperandTypes.ANY, OperandTypes.LITERAL), OperandTypes.family(SqlTypeFamily.ANY, SqlTypeFamily.NUMERIC)), SqlFunctionCategory.USER_DEFINED_FUNCTION, false, false);
        }
    }
}

