/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.aggregation;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.hive.druid.org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.hive.druid.org.apache.druid.segment.vector.VectorValueSelector;

public class LongSumVectorAggregator
implements VectorAggregator {
    private final VectorValueSelector selector;

    public LongSumVectorAggregator(VectorValueSelector selector) {
        this.selector = selector;
    }

    @Override
    public void init(ByteBuffer buf, int position) {
        buf.putLong(position, 0L);
    }

    @Override
    public void aggregate(ByteBuffer buf, int position, int startRow, int endRow) {
        long[] vector = this.selector.getLongVector();
        long sum = 0L;
        for (int i = startRow; i < endRow; ++i) {
            sum += vector[i];
        }
        buf.putLong(position, buf.getLong(position) + sum);
    }

    @Override
    public void aggregate(ByteBuffer buf, int numRows, int[] positions, @Nullable int[] rows, int positionOffset) {
        long[] vector = this.selector.getLongVector();
        for (int i = 0; i < numRows; ++i) {
            int position = positions[i] + positionOffset;
            buf.putLong(position, buf.getLong(position) + vector[rows != null ? rows[i] : i]);
        }
    }

    @Override
    public Object get(ByteBuffer buf, int position) {
        return buf.getLong(position);
    }

    @Override
    public void close() {
    }
}

