/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.aggregation;

import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.apache.hive.druid.org.apache.druid.java.util.common.ISE;
import org.apache.hive.druid.org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.hive.druid.org.apache.druid.query.filter.vector.ReadableVectorMatch;
import org.apache.hive.druid.org.apache.druid.query.filter.vector.VectorMatch;
import org.apache.hive.druid.org.apache.druid.query.filter.vector.VectorValueMatcher;

public class FilteredVectorAggregator
implements VectorAggregator {
    private final VectorValueMatcher matcher;
    private final VectorAggregator delegate;
    private final int[] delegatePositions;
    @Nullable
    private VectorMatch maskScratch = null;

    public FilteredVectorAggregator(VectorValueMatcher matcher, VectorAggregator delegate) {
        this.matcher = matcher;
        this.delegate = delegate;
        this.delegatePositions = new int[matcher.getMaxVectorSize()];
    }

    @Override
    public void init(ByteBuffer buf, int position) {
        this.delegate.init(buf, position);
    }

    @Override
    public void aggregate(ByteBuffer buf, int position, int startRow, int endRow) {
        ReadableVectorMatch mask;
        if (startRow == 0) {
            mask = VectorMatch.allTrue(endRow);
        } else {
            if (this.maskScratch == null) {
                this.maskScratch = VectorMatch.wrap(new int[this.matcher.getMaxVectorSize()]);
            }
            int maskSize = endRow - startRow;
            int[] maskArray = this.maskScratch.getSelection();
            for (int i = 0; i < maskSize; ++i) {
                maskArray[i] = startRow + i;
            }
            this.maskScratch.setSelectionSize(maskSize);
            mask = this.maskScratch;
        }
        ReadableVectorMatch match = this.matcher.match(mask);
        if (match.isAllTrue(this.matcher.getCurrentVectorSize())) {
            this.delegate.aggregate(buf, position, startRow, endRow);
        } else if (!match.isAllFalse()) {
            Arrays.fill(this.delegatePositions, 0, match.getSelectionSize(), position);
            this.delegate.aggregate(buf, match.getSelectionSize(), this.delegatePositions, match.getSelection(), 0);
        }
    }

    @Override
    public void aggregate(ByteBuffer buf, int numRows, int[] positions, @Nullable int[] rows, int positionOffset) {
        ReadableVectorMatch match0 = rows == null ? VectorMatch.allTrue(numRows) : VectorMatch.wrap(rows).setSelectionSize(numRows);
        ReadableVectorMatch match = this.matcher.match(match0);
        int[] selection = match.getSelection();
        if (rows == null) {
            for (int i = 0; i < match.getSelectionSize(); ++i) {
                this.delegatePositions[i] = positions[selection[i]];
            }
        } else {
            int j = 0;
            for (int i = 0; i < match.getSelectionSize(); ++i) {
                while (rows[j] < selection[i]) {
                    ++j;
                }
                if (rows[j] != selection[i]) {
                    throw new ISE("Selection contained phantom row[%d]", selection[i]);
                }
                this.delegatePositions[i] = positions[j];
            }
        }
        this.delegate.aggregate(buf, match.getSelectionSize(), this.delegatePositions, selection, positionOffset);
    }

    @Override
    public Object get(ByteBuffer buf, int position) {
        return this.delegate.get(buf, position);
    }

    @Override
    public void close() {
        this.delegate.close();
        this.maskScratch = null;
    }

    @Override
    public void relocate(int oldPosition, int newPosition, ByteBuffer oldBuffer, ByteBuffer newBuffer) {
        this.delegate.relocate(oldPosition, newPosition, oldBuffer, newBuffer);
    }
}

