/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query;

import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.MergeSequence;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.org.apache.druid.query.DataSource;
import org.apache.hive.druid.org.apache.druid.query.Query;
import org.apache.hive.druid.org.apache.druid.query.QueryPlus;
import org.apache.hive.druid.org.apache.druid.query.QueryRunner;
import org.apache.hive.druid.org.apache.druid.query.UnionDataSource;
import org.apache.hive.druid.org.apache.druid.query.context.ResponseContext;

public class UnionQueryRunner<T>
implements QueryRunner<T> {
    private final QueryRunner<T> baseRunner;

    public UnionQueryRunner(QueryRunner<T> baseRunner) {
        this.baseRunner = baseRunner;
    }

    @Override
    public Sequence<T> run(final QueryPlus<T> queryPlus, final ResponseContext responseContext) {
        final Query<T> query = queryPlus.getQuery();
        DataSource dataSource = query.getDataSource();
        if (dataSource instanceof UnionDataSource) {
            return new MergeSequence<T>(query.getResultOrdering(), Sequences.simple(Lists.transform(((UnionDataSource)dataSource).getDataSources(), new Function<DataSource, Sequence<T>>(){

                @Override
                public Sequence<T> apply(DataSource singleSource) {
                    return UnionQueryRunner.this.baseRunner.run(queryPlus.withQuery(query.withDataSource(singleSource)), responseContext);
                }
            })));
        }
        return this.baseRunner.run(queryPlus, responseContext);
    }
}

