/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.math.expr;

import java.util.Arrays;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.org.apache.druid.math.expr.ConstantExpr;
import org.apache.hive.druid.org.apache.druid.math.expr.Expr;
import org.apache.hive.druid.org.apache.druid.math.expr.ExprEval;

class StringArrayExpr
extends ConstantExpr {
    private final String[] value;

    StringArrayExpr(String[] value) {
        this.value = Preconditions.checkNotNull(value, "value");
    }

    @Override
    public Object getLiteralValue() {
        return this.value;
    }

    public String toString() {
        return Arrays.toString(this.value);
    }

    @Override
    public ExprEval eval(Expr.ObjectBinding bindings) {
        return ExprEval.ofStringArray(this.value);
    }
}

