/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.math.expr;

import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.math.expr.Expr;

abstract class BinaryOpExprBase
implements Expr {
    protected final String op;
    protected final Expr left;
    protected final Expr right;

    BinaryOpExprBase(String op, Expr left, Expr right) {
        this.op = op;
        this.left = left;
        this.right = right;
    }

    @Override
    public void visit(Expr.Visitor visitor) {
        this.left.visit(visitor);
        this.right.visit(visitor);
        visitor.visit(this);
    }

    @Override
    public Expr visit(Expr.Shuttle shuttle) {
        Expr newLeft = this.left.visit(shuttle);
        Expr newRight = this.right.visit(shuttle);
        if (this.left != newLeft || this.right != newRight) {
            return shuttle.visit(this.copy(newLeft, newRight));
        }
        return shuttle.visit(this);
    }

    public String toString() {
        return StringUtils.format("(%s %s %s)", this.op, this.left, this.right);
    }

    protected abstract BinaryOpExprBase copy(Expr var1, Expr var2);

    @Override
    public Expr.BindingDetails analyzeInputs() {
        return this.left.analyzeInputs().with(this.right).withScalarArguments(ImmutableSet.of(this.left, this.right));
    }
}

