/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.java.util.metrics;

import java.util.HashMap;
import java.util.Map;
import org.apache.hive.druid.org.apache.druid.java.util.common.logger.Logger;

public class KeyedDiff {
    private static final Logger log = new Logger(KeyedDiff.class);
    private final Map<String, Map<String, Long>> prevs = new HashMap<String, Map<String, Long>>();

    public Map<String, Long> to(String key, Map<String, Long> curr) {
        Map<String, Long> prev = this.prevs.put(key, curr);
        if (prev != null) {
            return KeyedDiff.subtract(curr, prev);
        }
        log.debug("No previous data for key[%s]", key);
        return null;
    }

    public static Map<String, Long> subtract(Map<String, Long> lhs, Map<String, Long> rhs) {
        assert (lhs.keySet().equals(rhs.keySet()));
        HashMap<String, Long> zs = new HashMap<String, Long>();
        for (Map.Entry<String, Long> k : lhs.entrySet()) {
            zs.put(k.getKey(), k.getValue() - rhs.get(k.getKey()));
        }
        return zs;
    }
}

