/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.java.util.metrics;

import java.util.Map;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.hive.druid.org.apache.druid.java.util.metrics.FeedDefiningMonitor;
import org.apache.hive.druid.org.apache.druid.java.util.metrics.MonitorUtils;
import org.apache.hive.druid.org.apache.druid.java.util.metrics.cgroups.CgroupDiscoverer;
import org.apache.hive.druid.org.apache.druid.java.util.metrics.cgroups.Memory;

public class CgroupMemoryMonitor
extends FeedDefiningMonitor {
    final CgroupDiscoverer cgroupDiscoverer;
    final Map<String, String[]> dimensions;

    public CgroupMemoryMonitor(CgroupDiscoverer cgroupDiscoverer, Map<String, String[]> dimensions, String feed) {
        super(feed);
        this.cgroupDiscoverer = cgroupDiscoverer;
        this.dimensions = dimensions;
    }

    public CgroupMemoryMonitor(Map<String, String[]> dimensions, String feed) {
        this(null, dimensions, feed);
    }

    public CgroupMemoryMonitor(Map<String, String[]> dimensions) {
        this(dimensions, "metrics");
    }

    public CgroupMemoryMonitor() {
        this(ImmutableMap.of());
    }

    @Override
    public boolean doMonitor(ServiceEmitter emitter) {
        Memory memory = new Memory(this.cgroupDiscoverer);
        Memory.MemoryStat stat = memory.snapshot();
        stat.getMemoryStats().forEach((key, value) -> {
            ServiceMetricEvent.Builder builder = this.builder();
            MonitorUtils.addDimensionsToBuilder(builder, this.dimensions);
            emitter.emit(builder.build(StringUtils.format("cgroup/memory/%s", key), (Number)value));
        });
        stat.getNumaMemoryStats().forEach((key, value) -> {
            ServiceMetricEvent.Builder builder = this.builder().setDimension("numaZone", Long.toString(key));
            MonitorUtils.addDimensionsToBuilder(builder, this.dimensions);
            value.forEach((k, v) -> emitter.emit(builder.build(StringUtils.format("cgroup/memory_numa/%s/pages", k), (Number)v)));
        });
        return true;
    }
}

