/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.java.util.emitter.core;

import javax.validation.constraints.NotNull;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.core.BaseHttpEmittingConfig;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.core.BatchingStrategy;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.core.ContentEncoding;
import org.apache.hive.druid.org.apache.druid.metadata.PasswordProvider;

public class HttpEmitterConfig
extends BaseHttpEmittingConfig {
    @NotNull
    @JsonProperty
    String recipientBaseUrl = null;

    public HttpEmitterConfig() {
    }

    public HttpEmitterConfig(BaseHttpEmittingConfig base, String recipientBaseUrl) {
        this.flushMillis = base.flushMillis;
        this.flushCount = base.flushCount;
        this.flushTimeOut = base.flushTimeOut;
        this.recipientBaseUrl = recipientBaseUrl;
        this.basicAuthentication = base.basicAuthentication;
        this.batchingStrategy = base.batchingStrategy;
        this.maxBatchSize = base.maxBatchSize;
        this.contentEncoding = base.contentEncoding;
        this.batchQueueSizeLimit = base.batchQueueSizeLimit;
        this.httpTimeoutAllowanceFactor = base.httpTimeoutAllowanceFactor;
        this.minHttpTimeoutMillis = base.minHttpTimeoutMillis;
    }

    public String getRecipientBaseUrl() {
        return this.recipientBaseUrl;
    }

    @Override
    public String toString() {
        return "HttpEmitterConfig{" + this.toStringBase() + ", recipientBaseUrl='" + this.recipientBaseUrl + '\'' + '}';
    }

    public static class Builder
    extends HttpEmitterConfig {
        public Builder(String recipientBaseUrl) {
            this.recipientBaseUrl = recipientBaseUrl;
        }

        public Builder setFlushMillis(long flushMillis) {
            this.flushMillis = flushMillis;
            return this;
        }

        public Builder setFlushTimeout(long flushTimeout) {
            this.flushTimeOut = flushTimeout;
            return this;
        }

        public Builder setFlushCount(int flushCount) {
            this.flushCount = flushCount;
            return this;
        }

        public Builder setBasicAuthentication(PasswordProvider basicAuthentication) {
            this.basicAuthentication = basicAuthentication;
            return this;
        }

        public Builder setBatchingStrategy(BatchingStrategy batchingStrategy) {
            this.batchingStrategy = batchingStrategy;
            return this;
        }

        public Builder setMaxBatchSize(int maxBatchSize) {
            this.maxBatchSize = maxBatchSize;
            return this;
        }

        public Builder setContentEncoding(ContentEncoding contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public Builder setBatchQueueSizeLimit(int batchQueueSizeLimit) {
            this.batchQueueSizeLimit = batchQueueSizeLimit;
            return this;
        }

        public Builder setHttpTimeoutAllowanceFactor(float httpTimeoutAllowanceFactor) {
            this.httpTimeoutAllowanceFactor = httpTimeoutAllowanceFactor;
            return this;
        }

        public HttpEmitterConfig build() {
            return new HttpEmitterConfig(this, this.recipientBaseUrl);
        }
    }
}

