/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.java.util.common.parsers;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import javax.annotation.Nullable;

public interface CloseableIterator<T>
extends Iterator<T>,
Closeable {
    default public <R> CloseableIterator<R> map(final Function<T, R> mapFunction) {
        final CloseableIterator delegate = this;
        return new CloseableIterator<R>(){

            @Override
            public boolean hasNext() {
                return delegate.hasNext();
            }

            @Override
            public R next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return mapFunction.apply(delegate.next());
            }

            @Override
            public void close() throws IOException {
                delegate.close();
            }
        };
    }

    default public <R> CloseableIterator<R> flatMap(final Function<T, CloseableIterator<R>> function) {
        final CloseableIterator delegate = this;
        return new CloseableIterator<R>(){
            CloseableIterator<R> iterator = this.findNextIeteratorIfNecessary();

            @Nullable
            private CloseableIterator<R> findNextIeteratorIfNecessary() {
                while ((this.iterator == null || !this.iterator.hasNext()) && delegate.hasNext()) {
                    if (this.iterator != null) {
                        try {
                            this.iterator.close();
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }
                    this.iterator = (CloseableIterator)function.apply(delegate.next());
                    if (!this.iterator.hasNext()) continue;
                    return this.iterator;
                }
                return null;
            }

            @Override
            public boolean hasNext() {
                return this.iterator != null && this.iterator.hasNext();
            }

            @Override
            public R next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                try {
                    Object e = this.iterator.next();
                    return e;
                }
                finally {
                    this.findNextIeteratorIfNecessary();
                }
            }

            @Override
            public void close() throws IOException {
                delegate.close();
            }
        };
    }
}

