/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.jackson;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.fasterxml.jackson.dataformat.smile.SmileFactory;
import org.apache.hive.druid.com.fasterxml.jackson.dataformat.smile.SmileGenerator;
import org.apache.hive.druid.org.apache.druid.guice.LazySingleton;
import org.apache.hive.druid.org.apache.druid.guice.annotations.Json;
import org.apache.hive.druid.org.apache.druid.guice.annotations.Smile;
import org.apache.hive.druid.org.apache.druid.jackson.DefaultObjectMapper;

public class JacksonModule
implements Module {
    public void configure(Binder binder) {
        binder.bind(ObjectMapper.class).to(Key.get(ObjectMapper.class, Json.class));
    }

    @Provides
    @LazySingleton
    @Json
    public ObjectMapper jsonMapper() {
        return new DefaultObjectMapper();
    }

    @Provides
    @LazySingleton
    @Smile
    public ObjectMapper smileMapper() {
        SmileFactory smileFactory = new SmileFactory();
        smileFactory.configure(SmileGenerator.Feature.ENCODE_BINARY_AS_7BIT, false);
        smileFactory.delegateToTextual(true);
        DefaultObjectMapper retVal = new DefaultObjectMapper(smileFactory);
        retVal.getFactory().setCodec(retVal);
        return retVal;
    }
}

