/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.initialization;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.Iterators;

public class ExtensionFirstClassLoader
extends URLClassLoader {
    private final ClassLoader druidLoader;

    public ExtensionFirstClassLoader(URL[] urls, ClassLoader druidLoader) {
        super(urls, (ClassLoader)null);
        this.druidLoader = Preconditions.checkNotNull(druidLoader, "druidLoader");
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> clazz = this.findLoadedClass(name);
            if (clazz == null) {
                try {
                    clazz = this.findClass(name);
                }
                catch (ClassNotFoundException e) {
                    return this.druidLoader.loadClass(name);
                }
            }
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
    }

    @Override
    public URL getResource(String name) {
        URL resourceFromExtension = super.getResource(name);
        if (resourceFromExtension != null) {
            return resourceFromExtension;
        }
        return this.druidLoader.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        ArrayList urls = new ArrayList();
        Iterators.addAll(urls, Iterators.forEnumeration(super.getResources(name)));
        Iterators.addAll(urls, Iterators.forEnumeration(this.druidLoader.getResources(name)));
        return Iterators.asEnumeration(urls.iterator());
    }
}

