/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.indexer.partitions;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.org.apache.druid.indexer.Checks;
import org.apache.hive.druid.org.apache.druid.indexer.Property;
import org.apache.hive.druid.org.apache.druid.indexer.partitions.DimensionBasedPartitionsSpec;
import org.apache.hive.druid.org.apache.druid.indexer.partitions.PartitionsSpec;

public class HashedPartitionsSpec
implements DimensionBasedPartitionsSpec {
    static final String NAME = "hashed";
    @VisibleForTesting
    static final String NUM_SHARDS = "numShards";
    private static final String FORCE_GUARANTEED_ROLLUP_COMPATIBLE = "";
    @Nullable
    private final Integer maxRowsPerSegment;
    @Nullable
    private final Integer numShards;
    private final List<String> partitionDimensions;

    public static HashedPartitionsSpec defaultSpec() {
        return new HashedPartitionsSpec(null, null, null, null, null);
    }

    @JsonCreator
    public HashedPartitionsSpec(@JsonProperty(value="targetRowsPerSegment") @Nullable Integer targetRowsPerSegment, @JsonProperty(value="numShards") @Nullable Integer numShards, @JsonProperty(value="partitionDimensions") @Nullable List<String> partitionDimensions, @Deprecated @JsonProperty(value="targetPartitionSize") @Nullable Integer targetPartitionSize, @Deprecated @JsonProperty(value="maxRowsPerSegment") @Nullable Integer maxRowsPerSegment) {
        Integer adjustedTargetRowsPerSegment = PartitionsSpec.resolveHistoricalNullIfNeeded(targetRowsPerSegment);
        Integer adjustedNumShards = PartitionsSpec.resolveHistoricalNullIfNeeded(numShards);
        Integer adjustedTargetPartitionSize = PartitionsSpec.resolveHistoricalNullIfNeeded(targetPartitionSize);
        Integer adjustedMaxRowsPerSegment = PartitionsSpec.resolveHistoricalNullIfNeeded(maxRowsPerSegment);
        Property<Integer> target = Checks.checkAtMostOneNotNull("targetRowsPerSegment", adjustedTargetRowsPerSegment, "targetPartitionSize", adjustedTargetPartitionSize);
        target = Checks.checkAtMostOneNotNull(target, new Property<Integer>("maxRowsPerSegment", adjustedMaxRowsPerSegment));
        Checks.checkAtMostOneNotNull(target, new Property<Integer>(NUM_SHARDS, adjustedNumShards));
        this.partitionDimensions = partitionDimensions == null ? Collections.emptyList() : partitionDimensions;
        this.numShards = adjustedNumShards;
        this.maxRowsPerSegment = target.getValue() == null ? (this.numShards == null ? Integer.valueOf(5000000) : null) : target.getValue();
        Preconditions.checkArgument(this.maxRowsPerSegment == null || this.maxRowsPerSegment > 0, "%s[%s] should be positive", target.getName(), target.getValue());
        Preconditions.checkArgument(this.numShards == null || this.numShards > 0, "numShards[%s] should be positive", this.numShards);
    }

    public HashedPartitionsSpec(@Nullable Integer maxRowsPerSegment, @Nullable Integer numShards, @Nullable List<String> partitionDimensions) {
        this(null, numShards, partitionDimensions, null, maxRowsPerSegment);
    }

    @Override
    @Nullable
    public Integer getTargetRowsPerSegment() {
        return null;
    }

    @Override
    @Nullable
    @JsonProperty
    public Integer getMaxRowsPerSegment() {
        return this.maxRowsPerSegment;
    }

    @Override
    public boolean needsDeterminePartitions(boolean useForHadoopTask) {
        return useForHadoopTask ? this.maxRowsPerSegment != null : this.numShards == null;
    }

    @Nullable
    @JsonProperty
    public Integer getNumShards() {
        return this.numShards;
    }

    @Override
    @JsonProperty
    public List<String> getPartitionDimensions() {
        return this.partitionDimensions;
    }

    @Override
    public String getForceGuaranteedRollupIncompatiblityReason() {
        return this.getNumShards() == null ? "numShards must be specified" : FORCE_GUARANTEED_ROLLUP_COMPATIBLE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HashedPartitionsSpec that = (HashedPartitionsSpec)o;
        return Objects.equals(this.maxRowsPerSegment, that.maxRowsPerSegment) && Objects.equals(this.numShards, that.numShards) && Objects.equals(this.partitionDimensions, that.partitionDimensions);
    }

    public int hashCode() {
        return Objects.hash(this.maxRowsPerSegment, this.numShards, this.partitionDimensions);
    }

    public String toString() {
        return "HashedPartitionsSpec{maxRowsPerSegment=" + this.maxRowsPerSegment + ", numShards=" + this.numShards + ", partitionDimensions=" + this.partitionDimensions + '}';
    }
}

