/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.guice;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.multibindings.MapBinder;
import java.util.List;
import org.apache.hive.druid.com.fasterxml.jackson.core.Version;
import org.apache.hive.druid.com.fasterxml.jackson.databind.Module;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.org.apache.druid.data.SearchableVersionedDataFinder;
import org.apache.hive.druid.org.apache.druid.guice.JsonConfigProvider;
import org.apache.hive.druid.org.apache.druid.guice.LazySingleton;
import org.apache.hive.druid.org.apache.druid.guice.PolyBind;
import org.apache.hive.druid.org.apache.druid.initialization.DruidModule;
import org.apache.hive.druid.org.apache.druid.segment.loading.DataSegmentKiller;
import org.apache.hive.druid.org.apache.druid.segment.loading.DataSegmentPusher;
import org.apache.hive.druid.org.apache.druid.segment.loading.LocalDataSegmentKiller;
import org.apache.hive.druid.org.apache.druid.segment.loading.LocalDataSegmentPusher;
import org.apache.hive.druid.org.apache.druid.segment.loading.LocalDataSegmentPusherConfig;
import org.apache.hive.druid.org.apache.druid.segment.loading.LocalFileTimestampVersionFinder;
import org.apache.hive.druid.org.apache.druid.segment.loading.LocalLoadSpec;
import org.apache.hive.druid.org.apache.druid.segment.loading.SegmentLoader;
import org.apache.hive.druid.org.apache.druid.segment.loading.SegmentLoaderLocalCacheManager;

public class LocalDataStorageDruidModule
implements DruidModule {
    public static final String SCHEME = "local";

    public void configure(Binder binder) {
        binder.bind(SegmentLoader.class).to(SegmentLoaderLocalCacheManager.class).in(LazySingleton.class);
        LocalDataStorageDruidModule.bindDeepStorageLocal(binder);
        PolyBind.createChoice(binder, "druid.storage.type", Key.get(DataSegmentPusher.class), Key.get(LocalDataSegmentPusher.class));
        PolyBind.createChoice(binder, "druid.storage.type", Key.get(DataSegmentKiller.class), Key.get(LocalDataSegmentKiller.class));
    }

    private static void bindDeepStorageLocal(Binder binder) {
        MapBinder.newMapBinder((Binder)binder, String.class, SearchableVersionedDataFinder.class).addBinding((Object)"file").to(LocalFileTimestampVersionFinder.class).in(LazySingleton.class);
        PolyBind.optionBinder(binder, Key.get(DataSegmentKiller.class)).addBinding((Object)SCHEME).to(LocalDataSegmentKiller.class).in(LazySingleton.class);
        PolyBind.optionBinder(binder, Key.get(DataSegmentPusher.class)).addBinding((Object)SCHEME).to(LocalDataSegmentPusher.class).in(LazySingleton.class);
        JsonConfigProvider.bind(binder, "druid.storage", LocalDataSegmentPusherConfig.class);
    }

    @Override
    public List<? extends Module> getJacksonModules() {
        return ImmutableList.of(new Module(){

            @Override
            public String getModuleName() {
                return "DruidLocalStorage-" + System.identityHashCode(this);
            }

            @Override
            public Version version() {
                return Version.unknownVersion();
            }

            @Override
            public void setupModule(Module.SetupContext context) {
                context.registerSubtypes(LocalLoadSpec.class);
            }
        });
    }
}

