/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.guice;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.List;
import org.apache.hive.druid.com.google.common.collect.Lists;

public class ListProvider<T>
implements Provider<List<T>> {
    private final List<Key<? extends T>> itemsToLoad = new ArrayList<Key<? extends T>>();
    private Injector injector;

    public ListProvider<T> add(Class<? extends T> clazz) {
        return this.add(Key.get(clazz));
    }

    public ListProvider<T> add(Key<? extends T> key) {
        this.itemsToLoad.add(key);
        return this;
    }

    @Inject
    private void configure(Injector injector) {
        this.injector = injector;
    }

    public List<T> get() {
        ArrayList<Object> retVal = Lists.newArrayListWithExpectedSize(this.itemsToLoad.size());
        for (Key<? extends T> key : this.itemsToLoad) {
            retVal.add(this.injector.getInstance(key));
        }
        return retVal;
    }
}

