/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.guice;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import org.apache.hive.druid.org.apache.druid.client.cache.Cache;
import org.apache.hive.druid.org.apache.druid.client.cache.CachePopulatorStats;
import org.apache.hive.druid.org.apache.druid.client.cache.CacheProvider;
import org.apache.hive.druid.org.apache.druid.guice.JsonConfigProvider;
import org.apache.hive.druid.org.apache.druid.guice.LazySingleton;
import org.apache.hive.druid.org.apache.druid.guice.ManageLifecycle;
import org.apache.hive.druid.org.apache.druid.guice.annotations.Global;

public class CacheModule
implements Module {
    public static final String DRUID_GLOBAL_CACHE_PREFIX = "druid.cache";
    public final String prefix;

    public CacheModule() {
        this.prefix = DRUID_GLOBAL_CACHE_PREFIX;
    }

    public CacheModule(String prefix) {
        this.prefix = prefix;
    }

    public void configure(Binder binder) {
        binder.bind(Cache.class).toProvider(Key.get(CacheProvider.class, Global.class)).in(ManageLifecycle.class);
        binder.bind(CachePopulatorStats.class).in(LazySingleton.class);
        JsonConfigProvider.bind(binder, this.prefix, CacheProvider.class, Global.class);
        binder.install((Module)new HybridCacheModule(this.prefix));
    }

    public static class HybridCacheModule
    implements Module {
        private final String prefix;

        public HybridCacheModule(String prefix) {
            this.prefix = prefix;
        }

        public void configure(Binder binder) {
            JsonConfigProvider.bind(binder, this.prefix + ".l1", CacheProvider.class, (Annotation)Names.named((String)"l1"));
            JsonConfigProvider.bind(binder, this.prefix + ".l2", CacheProvider.class, (Annotation)Names.named((String)"l2"));
        }
    }
}

