/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.data.input.impl.prefetch;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.commons.io.LineIterator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.org.apache.druid.data.input.Firehose;
import org.apache.hive.druid.org.apache.druid.data.input.impl.AbstractTextFilesFirehoseFactory;
import org.apache.hive.druid.org.apache.druid.data.input.impl.FileIteratingFirehose;
import org.apache.hive.druid.org.apache.druid.data.input.impl.StringInputRowParser;
import org.apache.hive.druid.org.apache.druid.data.input.impl.prefetch.CacheManager;
import org.apache.hive.druid.org.apache.druid.data.input.impl.prefetch.FetchConfig;
import org.apache.hive.druid.org.apache.druid.data.input.impl.prefetch.FileFetcher;
import org.apache.hive.druid.org.apache.druid.data.input.impl.prefetch.ObjectOpenFunction;
import org.apache.hive.druid.org.apache.druid.data.input.impl.prefetch.OpenObject;
import org.apache.hive.druid.org.apache.druid.java.util.common.ISE;
import org.apache.hive.druid.org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.hive.druid.org.apache.druid.java.util.common.logger.Logger;

public abstract class PrefetchableTextFilesFirehoseFactory<T>
extends AbstractTextFilesFirehoseFactory<T> {
    private static final Logger LOG = new Logger(PrefetchableTextFilesFirehoseFactory.class);
    private static final CacheManager DISABLED_CACHE_MANAGER = new CacheManager(0L);
    private static final FetchConfig DISABLED_PREFETCH_CONFIG = new FetchConfig(0L, 0L, 0L, 0L, 0);
    private final CacheManager<T> cacheManager;
    private final FetchConfig fetchConfig;
    private List<T> objects;

    public PrefetchableTextFilesFirehoseFactory(@Nullable Long maxCacheCapacityBytes, @Nullable Long maxFetchCapacityBytes, @Nullable Long prefetchTriggerBytes, @Nullable Long fetchTimeout, @Nullable Integer maxFetchRetry) {
        this.fetchConfig = new FetchConfig(maxCacheCapacityBytes, maxFetchCapacityBytes, prefetchTriggerBytes, fetchTimeout, maxFetchRetry);
        this.cacheManager = new CacheManager(this.fetchConfig.getMaxCacheCapacityBytes());
    }

    @JsonProperty
    public long getMaxCacheCapacityBytes() {
        return this.cacheManager.getMaxCacheCapacityBytes();
    }

    @JsonProperty
    public long getMaxFetchCapacityBytes() {
        return this.fetchConfig.getMaxFetchCapacityBytes();
    }

    @JsonProperty
    public long getPrefetchTriggerBytes() {
        return this.fetchConfig.getPrefetchTriggerBytes();
    }

    @JsonProperty
    public long getFetchTimeout() {
        return this.fetchConfig.getFetchTimeout();
    }

    @JsonProperty
    public int getMaxFetchRetry() {
        return this.fetchConfig.getMaxFetchRetry();
    }

    @VisibleForTesting
    CacheManager<T> getCacheManager() {
        return this.cacheManager;
    }

    @Override
    public Firehose connect(StringInputRowParser firehoseParser, @Nullable File temporaryDirectory) throws IOException {
        return this.connectInternal(firehoseParser, temporaryDirectory, this.fetchConfig, this.cacheManager);
    }

    @Override
    public Firehose connectForSampler(StringInputRowParser parser, @Nullable File temporaryDirectory) throws IOException {
        return this.connectInternal(parser, temporaryDirectory, DISABLED_PREFETCH_CONFIG, DISABLED_CACHE_MANAGER);
    }

    private Firehose connectInternal(StringInputRowParser firehoseParser, @Nullable File temporaryDirectory, FetchConfig fetchConfig, CacheManager cacheManager) throws IOException {
        if (this.objects == null) {
            this.objects = ImmutableList.copyOf(Preconditions.checkNotNull(this.initObjects(), "objects"));
        }
        if (cacheManager.isEnabled() || fetchConfig.getMaxFetchCapacityBytes() > 0L) {
            Preconditions.checkNotNull(temporaryDirectory, "temporaryDirectory");
            Preconditions.checkArgument(temporaryDirectory.exists(), "temporaryDirectory[%s] does not exist", temporaryDirectory);
            Preconditions.checkArgument(temporaryDirectory.isDirectory(), "temporaryDirectory[%s] is not a directory", temporaryDirectory);
        }
        LOG.info("Create a new firehose for [%d] objects", this.objects.size());
        ExecutorService fetchExecutor = Execs.singleThreaded("firehose_fetch_%d");
        final FileFetcher<T> fetcher = new FileFetcher<T>(cacheManager, this.objects, fetchExecutor, temporaryDirectory, fetchConfig, new ObjectOpenFunction<T>(){

            @Override
            public InputStream open(T object) throws IOException {
                return PrefetchableTextFilesFirehoseFactory.this.openObjectStream(object);
            }

            @Override
            public InputStream open(T object, long start) throws IOException {
                return PrefetchableTextFilesFirehoseFactory.this.openObjectStream(object, start);
            }
        }, this.getRetryCondition());
        return new FileIteratingFirehose(new Iterator<LineIterator>(){

            @Override
            public boolean hasNext() {
                return fetcher.hasNext();
            }

            @Override
            public LineIterator next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object openObject = fetcher.next();
                try {
                    return new ResourceCloseableLineIterator(new InputStreamReader(PrefetchableTextFilesFirehoseFactory.this.wrapObjectStream(((OpenObject)openObject).getObject(), ((OpenObject)openObject).getObjectStream()), StandardCharsets.UTF_8), ((OpenObject)openObject).getResourceCloser());
                }
                catch (IOException e) {
                    try {
                        ((OpenObject)openObject).getResourceCloser().close();
                    }
                    catch (Throwable t) {
                        e.addSuppressed(t);
                    }
                    throw new RuntimeException(e);
                }
            }
        }, firehoseParser, () -> {
            fetchExecutor.shutdownNow();
            try {
                Preconditions.checkState(fetchExecutor.awaitTermination(fetchConfig.getFetchTimeout(), TimeUnit.MILLISECONDS));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ISE("Failed to shutdown fetch executor during close", new Object[0]);
            }
        });
    }

    protected abstract Predicate<Throwable> getRetryCondition();

    protected abstract InputStream openObjectStream(T var1, long var2) throws IOException;

    static class ResourceCloseableLineIterator
    extends LineIterator {
        private final Closeable resourceCloser;

        ResourceCloseableLineIterator(Reader reader, Closeable resourceCloser) throws IllegalArgumentException {
            super(reader);
            this.resourceCloser = resourceCloser;
        }

        public void close() {
            try (Closeable ignore = this.resourceCloser;){
                super.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

