/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.data.input.impl.prefetch;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonParser;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonToken;
import org.apache.hive.druid.com.fasterxml.jackson.core.ObjectCodec;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.org.apache.druid.java.util.common.IAE;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.CloseQuietly;
import org.apache.hive.druid.org.apache.druid.java.util.common.io.Closer;

public class JsonIterator<T>
implements Iterator<T>,
Closeable {
    private JsonParser jp;
    private ObjectCodec objectCodec;
    private final TypeReference<T> typeRef;
    private final InputStream inputStream;
    private final Closeable resourceCloser;
    private final ObjectMapper objectMapper;

    public JsonIterator(TypeReference<T> typeRef, InputStream inputStream, Closeable resourceCloser, ObjectMapper objectMapper) {
        this.typeRef = typeRef;
        this.inputStream = inputStream;
        this.resourceCloser = resourceCloser;
        this.objectMapper = objectMapper;
        this.init();
    }

    @Override
    public boolean hasNext() {
        if (this.jp.isClosed()) {
            return false;
        }
        if (this.jp.getCurrentToken() == JsonToken.END_ARRAY) {
            CloseQuietly.close(this.jp);
            return false;
        }
        return true;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more objects to read!");
        }
        try {
            T retVal = this.objectCodec.readValue(this.jp, this.typeRef);
            this.jp.nextToken();
            return retVal;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void init() {
        try {
            if (this.inputStream == null) {
                throw new UnsupportedOperationException();
            }
            this.jp = this.objectMapper.getFactory().createParser(this.inputStream);
            JsonToken nextToken = this.jp.nextToken();
            if (nextToken != JsonToken.START_ARRAY) {
                throw new IAE("First token should be START_ARRAY, but it is actually [%s]", new Object[]{this.jp.getCurrentToken()});
            }
            this.jp.nextToken();
            this.objectCodec = this.jp.getCodec();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws IOException {
        Closer closer = Closer.create();
        if (this.jp != null) {
            closer.register(this.jp);
        }
        closer.register(this.resourceCloser);
        closer.close();
    }
}

