/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.data.input.impl;

import java.io.File;
import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.Iterators;
import org.apache.hive.druid.org.apache.druid.data.input.AbstractInputSource;
import org.apache.hive.druid.org.apache.druid.data.input.InputFormat;
import org.apache.hive.druid.org.apache.druid.data.input.InputRowSchema;
import org.apache.hive.druid.org.apache.druid.data.input.InputSourceReader;
import org.apache.hive.druid.org.apache.druid.data.input.InputSplit;
import org.apache.hive.druid.org.apache.druid.data.input.SplitHintSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.FileEntity;
import org.apache.hive.druid.org.apache.druid.data.input.impl.InputEntityIteratingReader;
import org.apache.hive.druid.org.apache.druid.data.input.impl.SplittableInputSource;

public class LocalInputSource
extends AbstractInputSource
implements SplittableInputSource<File> {
    private final File baseDir;
    private final String filter;

    @JsonCreator
    public LocalInputSource(@JsonProperty(value="baseDir") File baseDir, @JsonProperty(value="filter") String filter) {
        this.baseDir = baseDir;
        this.filter = filter;
    }

    @JsonProperty
    public File getBaseDir() {
        return this.baseDir;
    }

    @JsonProperty
    public String getFilter() {
        return this.filter;
    }

    @Override
    public Stream<InputSplit<File>> createSplits(InputFormat inputFormat, @Nullable SplitHintSpec splitHintSpec) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.getFileIterator(), 1), false).map(InputSplit::new);
    }

    @Override
    public int estimateNumSplits(InputFormat inputFormat, @Nullable SplitHintSpec splitHintSpec) {
        return Iterators.size(this.getFileIterator());
    }

    private Iterator<File> getFileIterator() {
        return FileUtils.iterateFiles((File)Preconditions.checkNotNull(this.baseDir).getAbsoluteFile(), (IOFileFilter)new WildcardFileFilter(this.filter), (IOFileFilter)TrueFileFilter.INSTANCE);
    }

    @Override
    public SplittableInputSource<File> withSplit(InputSplit<File> split) {
        File file = split.get();
        return new LocalInputSource(file.getParentFile(), file.getName());
    }

    @Override
    public boolean needsFormat() {
        return true;
    }

    @Override
    protected InputSourceReader formattableReader(InputRowSchema inputRowSchema, InputFormat inputFormat, @Nullable File temporaryDirectory) {
        return new InputEntityIteratingReader(inputRowSchema, inputFormat, this.createSplits(inputFormat, null).map(split -> new FileEntity((File)split.get())), temporaryDirectory);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalInputSource source = (LocalInputSource)o;
        return Objects.equals(this.baseDir, source.baseDir) && Objects.equals(this.filter, source.filter);
    }

    public int hashCode() {
        return Objects.hash(this.baseDir, this.filter);
    }
}

