/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.curator.cache;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.utils.CloseableExecutorService;
import org.apache.curator.utils.ThreadUtils;

public class PathChildrenCacheFactory {
    private final boolean cacheData;
    private final boolean compressed;
    private final ExecutorService exec;
    private final boolean shutdownExecutorOnClose;

    private PathChildrenCacheFactory(boolean cacheData, boolean compressed, ExecutorService exec, boolean shutdownExecutorOnClose) {
        this.cacheData = cacheData;
        this.compressed = compressed;
        this.exec = exec;
        this.shutdownExecutorOnClose = shutdownExecutorOnClose;
    }

    public PathChildrenCache make(CuratorFramework curator, String path) {
        return new PathChildrenCache(curator, path, this.cacheData, this.compressed, new CloseableExecutorService(this.exec, this.shutdownExecutorOnClose));
    }

    public static class Builder {
        private static final ThreadFactory DEFAULT_THREAD_FACTORY = ThreadUtils.newThreadFactory((String)"PathChildrenCache");
        private boolean cacheData = true;
        private boolean compressed = false;
        private ExecutorService exec = null;
        private boolean shutdownExecutorOnClose = true;

        public Builder withCacheData(boolean cacheData) {
            this.cacheData = cacheData;
            return this;
        }

        public Builder withCompressed(boolean compressed) {
            this.compressed = compressed;
            return this;
        }

        public Builder withExecutorService(ExecutorService exec) {
            this.exec = exec;
            return this;
        }

        public Builder withShutdownExecutorOnClose(boolean shutdownExecutorOnClose) {
            this.shutdownExecutorOnClose = shutdownExecutorOnClose;
            return this;
        }

        public PathChildrenCacheFactory build() {
            ExecutorService exec = this.exec != null ? this.exec : Builder.createDefaultExecutor();
            return new PathChildrenCacheFactory(this.cacheData, this.compressed, exec, this.shutdownExecutorOnClose);
        }

        public static ExecutorService createDefaultExecutor() {
            return Executors.newSingleThreadExecutor(DEFAULT_THREAD_FACTORY);
        }
    }
}

