/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.concurrent;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.AbstractQueuedLongSynchronizer;

public final class ConcurrentAwaitableCounter {
    private static final long MAX_COUNT = Long.MAX_VALUE;
    private final Sync sync = new Sync();

    public static long nextCount(long prevCount) {
        return prevCount + 1L & Long.MAX_VALUE;
    }

    public void increment() {
        this.sync.releaseShared(1L);
    }

    public void awaitCount(long totalCount) throws InterruptedException {
        ConcurrentAwaitableCounter.checkTotalCount(totalCount);
        long currentCount = this.sync.getCount();
        while (ConcurrentAwaitableCounter.compareCounts(totalCount, currentCount) > 0) {
            this.sync.acquireSharedInterruptibly(currentCount);
            currentCount = this.sync.getCount();
        }
    }

    private static void checkTotalCount(long totalCount) {
        if (totalCount < 0L) {
            throw new AssertionError((Object)"Total count must always be >= 0, even in the face of overflow. The next count should always be obtained by calling ConcurrentAwaitableCounter.nextCount(prevCount), not just +1");
        }
    }

    public void awaitCount(long totalCount, long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        ConcurrentAwaitableCounter.checkTotalCount(totalCount);
        long nanos = unit.toNanos(timeout);
        long currentCount = this.sync.getCount();
        while (ConcurrentAwaitableCounter.compareCounts(totalCount, currentCount) > 0) {
            if (!this.sync.tryAcquireSharedNanos(currentCount, nanos)) {
                throw new TimeoutException();
            }
            currentCount = this.sync.getCount();
        }
    }

    private static int compareCounts(long count1, long count2) {
        long diff = count1 - count2 & Long.MAX_VALUE;
        if (diff == 0L) {
            return 0;
        }
        return diff < 0x3FFFFFFFFFFFFFFFL ? 1 : -1;
    }

    public void awaitNextIncrements(long nextIncrements) throws InterruptedException {
        if (nextIncrements <= 0L) {
            throw new IllegalArgumentException("nextIncrements is not positive: " + nextIncrements);
        }
        if (nextIncrements > 0x1FFFFFFFFFFFFFFFL) {
            throw new UnsupportedOperationException("Couldn't wait for so many increments: " + nextIncrements);
        }
        this.awaitCount(this.sync.getCount() + nextIncrements & Long.MAX_VALUE);
    }

    public boolean awaitFirstIncrement(long timeout, TimeUnit unit) throws InterruptedException {
        return this.sync.tryAcquireSharedNanos(0L, unit.toNanos(timeout));
    }

    private static class Sync
    extends AbstractQueuedLongSynchronizer {
        private Sync() {
        }

        @Override
        protected long tryAcquireShared(long countWhenWaitStarted) {
            long currentCount = this.getState();
            return ConcurrentAwaitableCounter.compareCounts(currentCount, countWhenWaitStarted) > 0 ? 1L : -1L;
        }

        @Override
        protected boolean tryReleaseShared(long increment) {
            long nextCount;
            long count;
            while (!this.compareAndSetState(count = this.getState(), nextCount = count + increment & Long.MAX_VALUE)) {
            }
            return true;
        }

        long getCount() {
            return this.getState();
        }
    }
}

