/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.collections.spatial;

import java.nio.ByteBuffer;
import java.util.Iterator;
import org.apache.hive.druid.org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.hive.druid.org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.hive.druid.org.apache.druid.collections.spatial.ImmutablePoint;

public class ImmutableNode {
    public static final int HEADER_NUM_BYTES = 2;
    private final int numDims;
    private final int initialOffset;
    private final int offsetFromInitial;
    private final short numChildren;
    private final boolean isLeaf;
    private final int childrenOffset;
    private final ByteBuffer data;
    private final BitmapFactory bitmapFactory;

    public ImmutableNode(int numDims, int initialOffset, int offsetFromInitial, ByteBuffer data, BitmapFactory bitmapFactory) {
        this.bitmapFactory = bitmapFactory;
        this.numDims = numDims;
        this.initialOffset = initialOffset;
        this.offsetFromInitial = offsetFromInitial;
        short header = data.getShort(initialOffset + offsetFromInitial);
        this.isLeaf = (header & 0x8000) != 0;
        this.numChildren = (short)(header & Short.MAX_VALUE);
        int sizePosition = initialOffset + offsetFromInitial + 2 + 2 * numDims * 4;
        int bitmapSize = data.getInt(sizePosition);
        this.childrenOffset = initialOffset + offsetFromInitial + 2 + 2 * numDims * 4 + 4 + bitmapSize;
        this.data = data;
    }

    public ImmutableNode(int numDims, int initialOffset, int offsetFromInitial, short numChildren, boolean leaf, ByteBuffer data, BitmapFactory bitmapFactory) {
        this.bitmapFactory = bitmapFactory;
        this.numDims = numDims;
        this.initialOffset = initialOffset;
        this.offsetFromInitial = offsetFromInitial;
        this.numChildren = numChildren;
        this.isLeaf = leaf;
        int sizePosition = initialOffset + offsetFromInitial + 2 + 2 * numDims * 4;
        int bitmapSize = data.getInt(sizePosition);
        this.childrenOffset = initialOffset + offsetFromInitial + 2 + 2 * numDims * 4 + 4 + bitmapSize;
        this.data = data;
    }

    public BitmapFactory getBitmapFactory() {
        return this.bitmapFactory;
    }

    public int getInitialOffset() {
        return this.initialOffset;
    }

    public int getOffsetFromInitial() {
        return this.offsetFromInitial;
    }

    public int getNumDims() {
        return this.numDims;
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public float[] getMinCoordinates() {
        return this.getCoords(this.initialOffset + this.offsetFromInitial + 2);
    }

    public float[] getMaxCoordinates() {
        return this.getCoords(this.initialOffset + this.offsetFromInitial + 2 + this.numDims * 4);
    }

    public ImmutableBitmap getImmutableBitmap() {
        int sizePosition = this.initialOffset + this.offsetFromInitial + 2 + 2 * this.numDims * 4;
        int numBytes = this.data.getInt(sizePosition);
        this.data.position(sizePosition + 4);
        ByteBuffer tmpBuffer = this.data.slice();
        tmpBuffer.limit(numBytes);
        return this.bitmapFactory.mapImmutableBitmap(tmpBuffer.asReadOnlyBuffer());
    }

    public Iterable<ImmutableNode> getChildren() {
        return new Iterable<ImmutableNode>(){

            @Override
            public Iterator<ImmutableNode> iterator() {
                return new Iterator<ImmutableNode>(){
                    private int count = 0;

                    @Override
                    public boolean hasNext() {
                        return this.count < ImmutableNode.this.numChildren;
                    }

                    @Override
                    public ImmutableNode next() {
                        if (ImmutableNode.this.isLeaf) {
                            return new ImmutablePoint(ImmutableNode.this.numDims, ImmutableNode.this.initialOffset, ImmutableNode.this.data.getInt(ImmutableNode.this.childrenOffset + this.count++ * 4), ImmutableNode.this.data, ImmutableNode.this.bitmapFactory);
                        }
                        return new ImmutableNode(ImmutableNode.this.numDims, ImmutableNode.this.initialOffset, ImmutableNode.this.data.getInt(ImmutableNode.this.childrenOffset + this.count++ * 4), ImmutableNode.this.data, ImmutableNode.this.bitmapFactory);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public ByteBuffer getData() {
        return this.data;
    }

    private float[] getCoords(int offset) {
        float[] retVal = new float[this.numDims];
        ByteBuffer readOnlyBuffer = this.data.asReadOnlyBuffer();
        readOnlyBuffer.position(offset);
        readOnlyBuffer.asFloatBuffer().get(retVal);
        return retVal;
    }
}

