/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.collections.bitmap;

import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.org.roaringbitmap.IntIterator;
import org.apache.hive.druid.org.roaringbitmap.PeekableIntIterator;

public class PeekableIteratorAdapter<TIntIterator extends IntIterator>
implements PeekableIntIterator {
    static final int NOT_SET = -1;
    final TIntIterator baseIterator;
    int mark = -1;

    PeekableIteratorAdapter(TIntIterator iterator) {
        this.baseIterator = (IntIterator)Preconditions.checkNotNull(iterator, "iterator");
    }

    @Override
    public void advanceIfNeeded(int i) {
        while (this.mark < i && this.baseIterator.hasNext()) {
            this.mark = this.baseIterator.next();
        }
        if (this.mark < i) {
            this.mark = -1;
        }
    }

    @Override
    public int peekNext() {
        if (this.mark == -1) {
            this.mark = this.baseIterator.next();
        }
        return this.mark;
    }

    @Override
    public PeekableIntIterator clone() {
        throw new UnsupportedOperationException("PeekableIteratorAdapter.clone is not implemented, but this should not happen");
    }

    @Override
    public boolean hasNext() {
        return this.mark != -1 || this.baseIterator.hasNext();
    }

    @Override
    public int next() {
        if (this.mark != -1) {
            int currentBit = this.mark;
            this.mark = -1;
            return currentBit;
        }
        return this.baseIterator.next();
    }
}

