/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.client.cache;

public class CacheStats {
    private final long numHits;
    private final long numMisses;
    private final long size;
    private final long sizeInBytes;
    private final long numEvictions;
    private final long numTimeouts;
    private final long numErrors;

    public CacheStats(long numHits, long numMisses, long size, long sizeInBytes, long numEvictions, long numTimeouts, long numErrors) {
        this.numHits = numHits;
        this.numMisses = numMisses;
        this.size = size;
        this.sizeInBytes = sizeInBytes;
        this.numEvictions = numEvictions;
        this.numTimeouts = numTimeouts;
        this.numErrors = numErrors;
    }

    public long getNumHits() {
        return this.numHits;
    }

    public long getNumMisses() {
        return this.numMisses;
    }

    public long getNumEntries() {
        return this.size;
    }

    public long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public long getNumEvictions() {
        return this.numEvictions;
    }

    public long getNumTimeouts() {
        return this.numTimeouts;
    }

    public long getNumErrors() {
        return this.numErrors;
    }

    public long numLookups() {
        return this.numHits + this.numMisses;
    }

    public double hitRate() {
        long lookups = this.numLookups();
        return lookups == 0L ? 0.0 : (double)this.numHits / (double)lookups;
    }

    public long averageBytes() {
        return this.size == 0L ? 0L : this.sizeInBytes / this.size;
    }

    public CacheStats delta(CacheStats oldStats) {
        if (oldStats == null) {
            return this;
        }
        return new CacheStats(this.numHits - oldStats.numHits, this.numMisses - oldStats.numMisses, this.size - oldStats.size, this.sizeInBytes - oldStats.sizeInBytes, this.numEvictions - oldStats.numEvictions, this.numTimeouts - oldStats.numTimeouts, this.numErrors - oldStats.numErrors);
    }
}

