/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.client.cache;

import java.util.concurrent.atomic.AtomicLong;

public class CachePopulatorStats {
    private final AtomicLong okCounter = new AtomicLong();
    private final AtomicLong errorCounter = new AtomicLong();
    private final AtomicLong oversizedCounter = new AtomicLong();

    public void incrementOk() {
        this.okCounter.incrementAndGet();
    }

    public void incrementError() {
        this.errorCounter.incrementAndGet();
    }

    public void incrementOversized() {
        this.oversizedCounter.incrementAndGet();
    }

    public Snapshot snapshot() {
        return new Snapshot(this.okCounter.get(), this.errorCounter.get(), this.oversizedCounter.get());
    }

    public static class Snapshot {
        private final long numOk;
        private final long numError;
        private final long numOversized;

        Snapshot(long numOk, long numError, long numOversized) {
            this.numOk = numOk;
            this.numError = numError;
            this.numOversized = numOversized;
        }

        public long getNumOk() {
            return this.numOk;
        }

        public long getNumError() {
            return this.numError;
        }

        public long getNumOversized() {
            return this.numOversized;
        }

        public Snapshot delta(Snapshot oldSnapshot) {
            if (oldSnapshot == null) {
                return this;
            }
            return new Snapshot(this.numOk - oldSnapshot.numOk, this.numError - oldSnapshot.numError, this.numOversized - oldSnapshot.numOversized);
        }
    }
}

