/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hive.druid.org.apache.druid.client.TimelineServerView;
import org.apache.hive.druid.org.apache.druid.client.selector.ServerSelector;
import org.apache.hive.druid.org.apache.druid.query.DataSource;
import org.apache.hive.druid.org.apache.druid.query.LocatedSegmentDescriptor;
import org.apache.hive.druid.org.apache.druid.query.SegmentDescriptor;
import org.apache.hive.druid.org.apache.druid.query.TableDataSource;
import org.apache.hive.druid.org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.hive.druid.org.apache.druid.timeline.TimelineLookup;
import org.apache.hive.druid.org.apache.druid.timeline.TimelineObjectHolder;
import org.apache.hive.druid.org.apache.druid.timeline.partition.PartitionChunk;
import org.joda.time.Interval;

public class ServerViewUtil {
    public static List<LocatedSegmentDescriptor> getTargetLocations(TimelineServerView serverView, String datasource, List<Interval> intervals, int numCandidates) {
        return ServerViewUtil.getTargetLocations(serverView, new TableDataSource(datasource), intervals, numCandidates);
    }

    public static List<LocatedSegmentDescriptor> getTargetLocations(TimelineServerView serverView, DataSource datasource, List<Interval> intervals, int numCandidates) {
        TimelineLookup<String, ServerSelector> timeline = serverView.getTimeline(datasource);
        if (timeline == null) {
            return Collections.emptyList();
        }
        ArrayList<LocatedSegmentDescriptor> located = new ArrayList<LocatedSegmentDescriptor>();
        for (Interval interval : intervals) {
            for (TimelineObjectHolder<String, ServerSelector> holder : timeline.lookup(interval)) {
                for (PartitionChunk<ServerSelector> partitionChunk : holder.getObject()) {
                    ServerSelector selector = partitionChunk.getObject();
                    SegmentDescriptor descriptor = new SegmentDescriptor(holder.getInterval(), holder.getVersion(), partitionChunk.getChunkNumber());
                    long size = selector.getSegment().getSize();
                    List<DruidServerMetadata> candidates = selector.getCandidates(numCandidates);
                    located.add(new LocatedSegmentDescriptor(descriptor, size, candidates));
                }
            }
        }
        return located;
    }
}

