/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.client;

import java.util.Collection;
import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.ImmutableSortedMap;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;
import org.apache.hive.druid.org.apache.druid.timeline.SegmentId;

public class ImmutableDruidDataSource {
    private final String name;
    private final ImmutableMap<String, String> properties;
    private final ImmutableSortedMap<SegmentId, DataSegment> idToSegments;
    private final long totalSizeOfSegments;

    public ImmutableDruidDataSource(String name, Map<String, String> properties, Map<SegmentId, DataSegment> idToSegments) {
        this.name = Preconditions.checkNotNull(name);
        this.properties = ImmutableMap.copyOf(properties);
        this.idToSegments = ImmutableSortedMap.copyOf(idToSegments);
        this.totalSizeOfSegments = idToSegments.values().stream().mapToLong(DataSegment::getSize).sum();
    }

    @JsonCreator
    public ImmutableDruidDataSource(@JsonProperty(value="name") String name, @JsonProperty(value="properties") Map<String, String> properties, @JsonProperty(value="segments") Collection<DataSegment> segments) {
        this.name = Preconditions.checkNotNull(name);
        this.properties = ImmutableMap.copyOf(properties);
        ImmutableSortedMap.Builder idToSegmentsBuilder = ImmutableSortedMap.naturalOrder();
        long totalSizeOfSegments = 0L;
        for (DataSegment segment : segments) {
            idToSegmentsBuilder.put(segment.getId(), segment);
            totalSizeOfSegments += segment.getSize();
        }
        this.idToSegments = idToSegmentsBuilder.build();
        this.totalSizeOfSegments = totalSizeOfSegments;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @JsonProperty
    public Collection<DataSegment> getSegments() {
        return this.idToSegments.values();
    }

    @JsonIgnore
    public DataSegment getSegment(SegmentId segmentId) {
        return (DataSegment)this.idToSegments.get(segmentId);
    }

    @JsonIgnore
    public long getTotalSizeOfSegments() {
        return this.totalSizeOfSegments;
    }

    public String toString() {
        return "ImmutableDruidDataSource{name='" + this.name + "', # of segments='" + this.idToSegments.size() + "', properties='" + this.properties + "'}";
    }

    public boolean equals(Object o) {
        throw new UnsupportedOperationException("ImmutableDruidDataSource shouldn't be used as the key in containers");
    }

    public int hashCode() {
        throw new UnsupportedOperationException("ImmutableDruidDataSource shouldn't be used as the key in containers");
    }

    @VisibleForTesting
    public boolean equalsForTesting(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        ImmutableDruidDataSource that = (ImmutableDruidDataSource)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.properties.equals(that.properties)) {
            return false;
        }
        return this.idToSegments.equals(that.idToSegments);
    }
}

