/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.client;

import com.google.inject.Inject;
import java.io.IOException;
import java.lang.constant.Constable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ForkJoinPool;
import java.util.function.BinaryOperator;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Optional;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.collect.Ordering;
import org.apache.hive.druid.com.google.common.collect.RangeSet;
import org.apache.hive.druid.com.google.common.hash.Hasher;
import org.apache.hive.druid.com.google.common.hash.Hashing;
import org.apache.hive.druid.org.apache.druid.client.CacheUtil;
import org.apache.hive.druid.org.apache.druid.client.DruidServer;
import org.apache.hive.druid.org.apache.druid.client.ServerView;
import org.apache.hive.druid.org.apache.druid.client.TimelineServerView;
import org.apache.hive.druid.org.apache.druid.client.cache.Cache;
import org.apache.hive.druid.org.apache.druid.client.cache.CacheConfig;
import org.apache.hive.druid.org.apache.druid.client.cache.CachePopulator;
import org.apache.hive.druid.org.apache.druid.client.selector.QueryableDruidServer;
import org.apache.hive.druid.org.apache.druid.client.selector.ServerSelector;
import org.apache.hive.druid.org.apache.druid.guice.annotations.Client;
import org.apache.hive.druid.org.apache.druid.guice.annotations.Merging;
import org.apache.hive.druid.org.apache.druid.guice.annotations.Smile;
import org.apache.hive.druid.org.apache.druid.guice.http.DruidHttpClientConfig;
import org.apache.hive.druid.org.apache.druid.java.util.common.Intervals;
import org.apache.hive.druid.org.apache.druid.java.util.common.Pair;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.BaseSequence;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.LazySequence;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.ParallelMergeCombiningSequence;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.hive.druid.org.apache.druid.query.BySegmentResultValueClass;
import org.apache.hive.druid.org.apache.druid.query.CacheStrategy;
import org.apache.hive.druid.org.apache.druid.query.DruidProcessingConfig;
import org.apache.hive.druid.org.apache.druid.query.Query;
import org.apache.hive.druid.org.apache.druid.query.QueryContexts;
import org.apache.hive.druid.org.apache.druid.query.QueryMetrics;
import org.apache.hive.druid.org.apache.druid.query.QueryPlus;
import org.apache.hive.druid.org.apache.druid.query.QueryRunner;
import org.apache.hive.druid.org.apache.druid.query.QuerySegmentWalker;
import org.apache.hive.druid.org.apache.druid.query.QueryToolChest;
import org.apache.hive.druid.org.apache.druid.query.QueryToolChestWarehouse;
import org.apache.hive.druid.org.apache.druid.query.Result;
import org.apache.hive.druid.org.apache.druid.query.SegmentDescriptor;
import org.apache.hive.druid.org.apache.druid.query.aggregation.MetricManipulatorFns;
import org.apache.hive.druid.org.apache.druid.query.context.ResponseContext;
import org.apache.hive.druid.org.apache.druid.query.filter.DimFilterUtils;
import org.apache.hive.druid.org.apache.druid.query.spec.MultipleSpecificSegmentSpec;
import org.apache.hive.druid.org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;
import org.apache.hive.druid.org.apache.druid.timeline.SegmentId;
import org.apache.hive.druid.org.apache.druid.timeline.TimelineLookup;
import org.apache.hive.druid.org.apache.druid.timeline.TimelineObjectHolder;
import org.apache.hive.druid.org.apache.druid.timeline.VersionedIntervalTimeline;
import org.apache.hive.druid.org.apache.druid.timeline.partition.PartitionChunk;
import org.apache.hive.druid.org.apache.druid.timeline.partition.PartitionHolder;
import org.joda.time.Interval;

public class CachingClusteredClient
implements QuerySegmentWalker {
    private static final EmittingLogger log = new EmittingLogger(CachingClusteredClient.class);
    private final QueryToolChestWarehouse warehouse;
    private final TimelineServerView serverView;
    private final Cache cache;
    private final ObjectMapper objectMapper;
    private final CachePopulator cachePopulator;
    private final CacheConfig cacheConfig;
    private final DruidHttpClientConfig httpClientConfig;
    private final DruidProcessingConfig processingConfig;
    private final ForkJoinPool pool;

    @Inject
    public CachingClusteredClient(QueryToolChestWarehouse warehouse, TimelineServerView serverView, Cache cache, @Smile ObjectMapper objectMapper, CachePopulator cachePopulator, CacheConfig cacheConfig, @Client DruidHttpClientConfig httpClientConfig, DruidProcessingConfig processingConfig, @Merging ForkJoinPool pool) {
        this.warehouse = warehouse;
        this.serverView = serverView;
        this.cache = cache;
        this.objectMapper = objectMapper;
        this.cachePopulator = cachePopulator;
        this.cacheConfig = cacheConfig;
        this.httpClientConfig = httpClientConfig;
        this.processingConfig = processingConfig;
        this.pool = pool;
        if (cacheConfig.isQueryCacheable("groupBy") && (cacheConfig.isUseCache() || cacheConfig.isPopulateCache())) {
            log.warn("Even though groupBy caching is enabled in your configuration, v2 groupBys will not be cached on the broker. Consider enabling caching on your data nodes if it is not already enabled.", new Object[0]);
        }
        serverView.registerSegmentCallback(Execs.singleThreaded("CCClient-ServerView-CB-%d"), new ServerView.BaseSegmentCallback(){

            @Override
            public ServerView.CallbackAction segmentRemoved(DruidServerMetadata server, DataSegment segment) {
                CachingClusteredClient.this.cache.close(segment.getId().toString());
                return ServerView.CallbackAction.CONTINUE;
            }
        });
    }

    @Override
    public <T> QueryRunner<T> getQueryRunnerForIntervals(Query<T> query, Iterable<Interval> intervals) {
        return new QueryRunner<T>(){

            @Override
            public Sequence<T> run(QueryPlus<T> queryPlus, ResponseContext responseContext) {
                return CachingClusteredClient.this.run(queryPlus, responseContext, timeline -> timeline);
            }
        };
    }

    private <T> Sequence<T> run(QueryPlus<T> queryPlus, ResponseContext responseContext, UnaryOperator<TimelineLookup<String, ServerSelector>> timelineConverter) {
        return new SpecificQueryRunnable<T>(queryPlus, responseContext).run(timelineConverter);
    }

    @Override
    public <T> QueryRunner<T> getQueryRunnerForSegments(Query<T> query, final Iterable<SegmentDescriptor> specs) {
        return new QueryRunner<T>(){

            @Override
            public Sequence<T> run(QueryPlus<T> queryPlus, ResponseContext responseContext) {
                return CachingClusteredClient.this.run(queryPlus, responseContext, timeline -> {
                    VersionedIntervalTimeline timeline2 = new VersionedIntervalTimeline(Ordering.natural());
                    for (SegmentDescriptor spec : specs) {
                        PartitionChunk chunk;
                        PartitionHolder entry = timeline.findEntry(spec.getInterval(), spec.getVersion());
                        if (entry == null || (chunk = entry.getChunk(spec.getPartitionNumber())) == null) continue;
                        timeline2.add(spec.getInterval(), spec.getVersion(), chunk);
                    }
                    return timeline2;
                });
            }
        };
    }

    private static class ServerToSegment
    extends Pair<ServerSelector, SegmentDescriptor> {
        private ServerToSegment(ServerSelector server, SegmentDescriptor segment) {
            super(server, segment);
        }

        ServerSelector getServer() {
            return (ServerSelector)this.lhs;
        }

        SegmentDescriptor getSegmentDescriptor() {
            return (SegmentDescriptor)this.rhs;
        }
    }

    private class SpecificQueryRunnable<T> {
        private final QueryPlus<T> queryPlus;
        private final ResponseContext responseContext;
        private final Query<T> query;
        private final QueryToolChest<T, Query<T>> toolChest;
        @Nullable
        private final CacheStrategy<T, Object, Query<T>> strategy;
        private final boolean useCache;
        private final boolean populateCache;
        private final boolean isBySegment;
        private final int uncoveredIntervalsLimit;
        private final Query<T> downstreamQuery;
        private final Map<String, Cache.NamedKey> cachePopulatorKeyMap = new HashMap<String, Cache.NamedKey>();
        private final List<Interval> intervals;

        SpecificQueryRunnable(QueryPlus<T> queryPlus, ResponseContext responseContext) {
            this.queryPlus = queryPlus;
            this.responseContext = responseContext;
            this.query = queryPlus.getQuery();
            this.toolChest = CachingClusteredClient.this.warehouse.getToolChest(this.query);
            this.strategy = this.toolChest.getCacheStrategy(this.query);
            this.useCache = CacheUtil.useCacheOnBrokers(this.query, this.strategy, CachingClusteredClient.this.cacheConfig);
            this.populateCache = CacheUtil.populateCacheOnBrokers(this.query, this.strategy, CachingClusteredClient.this.cacheConfig);
            this.isBySegment = QueryContexts.isBySegment(this.query);
            this.uncoveredIntervalsLimit = QueryContexts.getUncoveredIntervalsLimit(this.query);
            this.downstreamQuery = this.query.withOverriddenContext(this.makeDownstreamQueryContext());
            this.intervals = this.query.getIntervalsOfInnerMostQuery();
        }

        private ImmutableMap<String, Object> makeDownstreamQueryContext() {
            ImmutableMap.Builder<String, Constable> contextBuilder = new ImmutableMap.Builder<String, Constable>();
            int priority = QueryContexts.getPriority(this.query);
            contextBuilder.put("priority", Integer.valueOf(priority));
            if (this.populateCache) {
                contextBuilder.put("populateCache", Boolean.valueOf(false));
                contextBuilder.put("bySegment", Boolean.valueOf(true));
            }
            return contextBuilder.build();
        }

        Sequence<T> run(UnaryOperator<TimelineLookup<String, ServerSelector>> timelineConverter) {
            TimelineLookup timeline = CachingClusteredClient.this.serverView.getTimeline(this.query.getDataSource());
            if (timeline == null) {
                return Sequences.empty();
            }
            timeline = (TimelineLookup)timelineConverter.apply(timeline);
            if (this.uncoveredIntervalsLimit > 0) {
                this.computeUncoveredIntervals(timeline);
            }
            Set<ServerToSegment> segments = this.computeSegmentsToQuery(timeline);
            byte[] queryCacheKey = this.computeQueryCacheKey();
            if (this.query.getContext().get("If-None-Match") != null) {
                String prevEtag = (String)this.query.getContext().get("If-None-Match");
                String currentEtag = this.computeCurrentEtag(segments, queryCacheKey);
                if (currentEtag != null && currentEtag.equals(prevEtag)) {
                    return Sequences.empty();
                }
            }
            List<Pair<Interval, byte[]>> alreadyCachedResults = this.pruneSegmentsWithCachedResults(queryCacheKey, segments);
            SortedMap<DruidServer, List<SegmentDescriptor>> segmentsByServer = this.groupSegmentsByServer(segments);
            return new LazySequence(() -> {
                ArrayList<Sequence<T>> sequencesByInterval = new ArrayList<Sequence<T>>(alreadyCachedResults.size() + segmentsByServer.size());
                this.addSequencesFromCache(sequencesByInterval, alreadyCachedResults);
                this.addSequencesFromServer(sequencesByInterval, segmentsByServer);
                return this.merge(sequencesByInterval);
            });
        }

        private Sequence<T> merge(List<Sequence<T>> sequencesByInterval) {
            BinaryOperator<T> mergeFn = this.toolChest.createMergeFn(this.query);
            if (CachingClusteredClient.this.processingConfig.useParallelMergePool() && QueryContexts.getEnableParallelMerges(this.query) && mergeFn != null) {
                return new ParallelMergeCombiningSequence<T>(CachingClusteredClient.this.pool, sequencesByInterval, this.query.getResultOrdering(), mergeFn, QueryContexts.hasTimeout(this.query), QueryContexts.getTimeout(this.query), QueryContexts.getPriority(this.query), QueryContexts.getParallelMergeParallelism(this.query, CachingClusteredClient.this.processingConfig.getMergePoolDefaultMaxQueryParallelism()), QueryContexts.getParallelMergeInitialYieldRows(this.query, CachingClusteredClient.this.processingConfig.getMergePoolTaskInitialYieldRows()), QueryContexts.getParallelMergeSmallBatchRows(this.query, CachingClusteredClient.this.processingConfig.getMergePoolSmallBatchRows()), CachingClusteredClient.this.processingConfig.getMergePoolTargetTaskRunTimeMillis(), reportMetrics -> {
                    QueryMetrics<?> queryMetrics = this.queryPlus.getQueryMetrics();
                    if (queryMetrics != null) {
                        queryMetrics.parallelMergeParallelism(reportMetrics.getParallelism());
                        queryMetrics.reportParallelMergeParallelism(reportMetrics.getParallelism());
                        queryMetrics.reportParallelMergeInputSequences(reportMetrics.getInputSequences());
                        queryMetrics.reportParallelMergeInputRows(reportMetrics.getInputRows());
                        queryMetrics.reportParallelMergeOutputRows(reportMetrics.getOutputRows());
                        queryMetrics.reportParallelMergeTaskCount(reportMetrics.getTaskCount());
                        queryMetrics.reportParallelMergeTotalCpuTime(reportMetrics.getTotalCpuTime());
                    }
                });
            }
            return Sequences.simple(sequencesByInterval).flatMerge(seq -> seq, this.query.getResultOrdering());
        }

        private Set<ServerToSegment> computeSegmentsToQuery(TimelineLookup<String, ServerSelector> timeline) {
            List serversLookup = this.toolChest.filterSegments(this.query, this.intervals.stream().flatMap(i -> timeline.lookup((Interval)i).stream()).collect(Collectors.toList()));
            LinkedHashSet<ServerToSegment> segments = new LinkedHashSet<ServerToSegment>();
            HashMap<String, Optional<RangeSet<String>>> dimensionRangeCache = new HashMap<String, Optional<RangeSet<String>>>();
            for (TimelineObjectHolder holder : serversLookup) {
                Set<PartitionChunk> filteredChunks = DimFilterUtils.filterShards(this.query.getFilter(), holder.getObject(), partitionChunk -> ((ServerSelector)partitionChunk.getObject()).getSegment().getShardSpec(), dimensionRangeCache);
                for (PartitionChunk chunk : filteredChunks) {
                    ServerSelector server = (ServerSelector)chunk.getObject();
                    SegmentDescriptor segment = new SegmentDescriptor(holder.getInterval(), (String)holder.getVersion(), chunk.getChunkNumber());
                    segments.add(new ServerToSegment(server, segment));
                }
            }
            return segments;
        }

        private void computeUncoveredIntervals(TimelineLookup<String, ServerSelector> timeline) {
            ArrayList<Interval> uncoveredIntervals = new ArrayList<Interval>(this.uncoveredIntervalsLimit);
            boolean uncoveredIntervalsOverflowed = false;
            for (Interval interval : this.intervals) {
                List<TimelineObjectHolder<String, ServerSelector>> lookup = timeline.lookup(interval);
                long startMillis = interval.getStartMillis();
                long endMillis = interval.getEndMillis();
                for (TimelineObjectHolder timelineObjectHolder : lookup) {
                    Interval holderInterval = timelineObjectHolder.getInterval();
                    long intervalStart = holderInterval.getStartMillis();
                    if (!uncoveredIntervalsOverflowed && startMillis != intervalStart) {
                        if (this.uncoveredIntervalsLimit > uncoveredIntervals.size()) {
                            uncoveredIntervals.add(Intervals.utc(startMillis, intervalStart));
                        } else {
                            uncoveredIntervalsOverflowed = true;
                        }
                    }
                    startMillis = holderInterval.getEndMillis();
                }
                if (uncoveredIntervalsOverflowed || startMillis >= endMillis) continue;
                if (this.uncoveredIntervalsLimit > uncoveredIntervals.size()) {
                    uncoveredIntervals.add(Intervals.utc(startMillis, endMillis));
                    continue;
                }
                uncoveredIntervalsOverflowed = true;
            }
            if (!uncoveredIntervals.isEmpty()) {
                this.responseContext.add(ResponseContext.Key.UNCOVERED_INTERVALS, uncoveredIntervals);
                this.responseContext.add(ResponseContext.Key.UNCOVERED_INTERVALS_OVERFLOWED, uncoveredIntervalsOverflowed);
            }
        }

        @Nullable
        private byte[] computeQueryCacheKey() {
            if ((this.populateCache || this.useCache) && !this.isBySegment) {
                assert (this.strategy != null);
                return this.strategy.computeCacheKey(this.query);
            }
            return null;
        }

        @Nullable
        private String computeCurrentEtag(Set<ServerToSegment> segments, @Nullable byte[] queryCacheKey) {
            Hasher hasher = Hashing.sha1().newHasher();
            boolean hasOnlyHistoricalSegments = true;
            for (ServerToSegment p : segments) {
                if (!p.getServer().pick().getServer().segmentReplicatable()) {
                    hasOnlyHistoricalSegments = false;
                    break;
                }
                hasher.putString(p.getServer().getSegment().getId().toString(), StandardCharsets.UTF_8);
                hasher.putString(((SegmentDescriptor)p.rhs).getInterval().toString(), StandardCharsets.UTF_8);
            }
            if (hasOnlyHistoricalSegments) {
                hasher.putBytes(queryCacheKey == null ? this.strategy.computeCacheKey(this.query) : queryCacheKey);
                String currEtag = StringUtils.encodeBase64String(hasher.hash().asBytes());
                this.responseContext.put(ResponseContext.Key.ETAG, currEtag);
                return currEtag;
            }
            return null;
        }

        private List<Pair<Interval, byte[]>> pruneSegmentsWithCachedResults(byte[] queryCacheKey, Set<ServerToSegment> segments) {
            if (queryCacheKey == null) {
                return Collections.emptyList();
            }
            ArrayList<Pair<Interval, byte[]>> alreadyCachedResults = new ArrayList<Pair<Interval, byte[]>>();
            Map<ServerToSegment, Cache.NamedKey> perSegmentCacheKeys = this.computePerSegmentCacheKeys(segments, queryCacheKey);
            Map<Cache.NamedKey, byte[]> cachedValues = this.computeCachedValues(perSegmentCacheKeys);
            perSegmentCacheKeys.forEach((segment, segmentCacheKey) -> {
                Interval segmentQueryInterval = segment.getSegmentDescriptor().getInterval();
                byte[] cachedValue = (byte[])cachedValues.get(segmentCacheKey);
                if (cachedValue != null) {
                    segments.remove(segment);
                    alreadyCachedResults.add(Pair.of(segmentQueryInterval, cachedValue));
                } else if (this.populateCache) {
                    SegmentId segmentId = segment.getServer().getSegment().getId();
                    this.addCachePopulatorKey((Cache.NamedKey)segmentCacheKey, segmentId, segmentQueryInterval);
                }
            });
            return alreadyCachedResults;
        }

        private Map<ServerToSegment, Cache.NamedKey> computePerSegmentCacheKeys(Set<ServerToSegment> segments, byte[] queryCacheKey) {
            LinkedHashMap<ServerToSegment, Cache.NamedKey> cacheKeys = Maps.newLinkedHashMap();
            for (ServerToSegment serverToSegment : segments) {
                Cache.NamedKey segmentCacheKey = CacheUtil.computeSegmentCacheKey(serverToSegment.getServer().getSegment().getId().toString(), serverToSegment.getSegmentDescriptor(), queryCacheKey);
                cacheKeys.put(serverToSegment, segmentCacheKey);
            }
            return cacheKeys;
        }

        private Map<Cache.NamedKey, byte[]> computeCachedValues(Map<ServerToSegment, Cache.NamedKey> cacheKeys) {
            if (this.useCache) {
                return CachingClusteredClient.this.cache.getBulk(Iterables.limit(cacheKeys.values(), CachingClusteredClient.this.cacheConfig.getCacheBulkMergeLimit()));
            }
            return ImmutableMap.of();
        }

        private void addCachePopulatorKey(Cache.NamedKey segmentCacheKey, SegmentId segmentId, Interval segmentQueryInterval) {
            this.cachePopulatorKeyMap.put(StringUtils.format("%s_%s", segmentId, segmentQueryInterval), segmentCacheKey);
        }

        @Nullable
        private Cache.NamedKey getCachePopulatorKey(String segmentId, Interval segmentInterval) {
            return this.cachePopulatorKeyMap.get(StringUtils.format("%s_%s", segmentId, segmentInterval));
        }

        private SortedMap<DruidServer, List<SegmentDescriptor>> groupSegmentsByServer(Set<ServerToSegment> segments) {
            TreeMap<DruidServer, List<SegmentDescriptor>> serverSegments = new TreeMap<DruidServer, List<SegmentDescriptor>>();
            for (ServerToSegment serverToSegment : segments) {
                QueryableDruidServer queryableDruidServer = serverToSegment.getServer().pick();
                if (queryableDruidServer == null) {
                    log.makeAlert("No servers found for SegmentDescriptor[%s] for DataSource[%s]?! How can this be?!", serverToSegment.getSegmentDescriptor(), this.query.getDataSource()).emit();
                    continue;
                }
                DruidServer server = queryableDruidServer.getServer();
                serverSegments.computeIfAbsent(server, s -> new ArrayList()).add(serverToSegment.getSegmentDescriptor());
            }
            return serverSegments;
        }

        private void addSequencesFromCache(List<Sequence<T>> listOfSequences, List<Pair<Interval, byte[]>> cachedResults) {
            if (this.strategy == null) {
                return;
            }
            Function<Object, T> pullFromCacheFunction = this.strategy.pullFromSegmentLevelCache();
            final TypeReference<Object> cacheObjectClazz = this.strategy.getCacheObjectClazz();
            for (Pair<Interval, byte[]> cachedResultPair : cachedResults) {
                final byte[] cachedResult = (byte[])cachedResultPair.rhs;
                BaseSequence<Object, Iterator<Object>> cachedSequence = new BaseSequence<Object, Iterator<Object>>(new BaseSequence.IteratorMaker<Object, Iterator<Object>>(){

                    @Override
                    public Iterator<Object> make() {
                        try {
                            if (cachedResult.length == 0) {
                                return Collections.emptyIterator();
                            }
                            return CachingClusteredClient.this.objectMapper.readValues(CachingClusteredClient.this.objectMapper.getFactory().createParser(cachedResult), cacheObjectClazz);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }

                    @Override
                    public void cleanup(Iterator<Object> iterFromMake) {
                    }
                });
                listOfSequences.add(Sequences.map(cachedSequence, pullFromCacheFunction));
            }
        }

        private void addSequencesFromServer(List<Sequence<T>> listOfSequences, SortedMap<DruidServer, List<SegmentDescriptor>> segmentsByServer) {
            segmentsByServer.forEach((server, segmentsOfServer) -> {
                QueryRunner serverRunner = CachingClusteredClient.this.serverView.getQueryRunner((DruidServer)server);
                if (serverRunner == null) {
                    log.error("Server[%s] doesn't have a query runner", server);
                    return;
                }
                MultipleSpecificSegmentSpec segmentsOfServerSpec = new MultipleSpecificSegmentSpec((List<SegmentDescriptor>)segmentsOfServer);
                long maxQueuedBytes = QueryContexts.getMaxQueuedBytes(this.query, CachingClusteredClient.this.httpClientConfig.getMaxQueuedBytes());
                long maxQueuedBytesPerServer = maxQueuedBytes / (long)segmentsByServer.size();
                Sequence<T> serverResults = this.isBySegment ? this.getBySegmentServerResults(serverRunner, segmentsOfServerSpec, maxQueuedBytesPerServer) : (!server.segmentReplicatable() || !this.populateCache ? this.getSimpleServerResults(serverRunner, segmentsOfServerSpec, maxQueuedBytesPerServer) : this.getAndCacheServerResults(serverRunner, segmentsOfServerSpec, maxQueuedBytesPerServer));
                listOfSequences.add(serverResults);
            });
        }

        private Sequence<T> getBySegmentServerResults(QueryRunner serverRunner, MultipleSpecificSegmentSpec segmentsOfServerSpec, long maxQueuedBytesPerServer) {
            Sequence<Result> resultsBySegments = serverRunner.run(this.queryPlus.withQuerySegmentSpec(segmentsOfServerSpec).withMaxQueuedBytes(maxQueuedBytesPerServer), this.responseContext);
            return resultsBySegments.map(result -> result.map(resultsOfSegment -> resultsOfSegment.mapResults(this.toolChest.makePreComputeManipulatorFn(this.query, MetricManipulatorFns.deserializing())::apply)));
        }

        private Sequence<T> getSimpleServerResults(QueryRunner serverRunner, MultipleSpecificSegmentSpec segmentsOfServerSpec, long maxQueuedBytesPerServer) {
            return serverRunner.run(this.queryPlus.withQuerySegmentSpec(segmentsOfServerSpec).withMaxQueuedBytes(maxQueuedBytesPerServer), this.responseContext);
        }

        private Sequence<T> getAndCacheServerResults(QueryRunner serverRunner, MultipleSpecificSegmentSpec segmentsOfServerSpec, long maxQueuedBytesPerServer) {
            Sequence<Result> resultsBySegments = serverRunner.run(this.queryPlus.withQuery(this.downstreamQuery).withQuerySegmentSpec(segmentsOfServerSpec).withMaxQueuedBytes(maxQueuedBytesPerServer), this.responseContext);
            Function<T, Object> cacheFn = this.strategy.prepareForSegmentLevelCache();
            return resultsBySegments.map(result -> {
                BySegmentResultValueClass resultsOfSegment = (BySegmentResultValueClass)result.getValue();
                Cache.NamedKey cachePopulatorKey = this.getCachePopulatorKey(resultsOfSegment.getSegmentId(), resultsOfSegment.getInterval());
                Sequence<Object> res = Sequences.simple(resultsOfSegment.getResults());
                if (cachePopulatorKey != null) {
                    res = CachingClusteredClient.this.cachePopulator.wrap(res, cacheFn::apply, CachingClusteredClient.this.cache, cachePopulatorKey);
                }
                return res.map(this.toolChest.makePreComputeManipulatorFn(this.downstreamQuery, MetricManipulatorFns.deserializing())::apply);
            }).flatMerge(seq -> seq, this.query.getResultOrdering());
        }
    }
}

