/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.tools;

import java.util.ArrayList;
import java.util.List;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.org.apache.calcite.linq4j.Ord;
import org.apache.hive.druid.org.apache.calcite.plan.Context;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptCluster;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptSchema;
import org.apache.hive.druid.org.apache.calcite.rel.RelNode;
import org.apache.hive.druid.org.apache.calcite.rel.core.JoinRelType;
import org.apache.hive.druid.org.apache.calcite.rel.core.TableScan;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.rex.RexNode;
import org.apache.hive.druid.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.hive.druid.org.apache.calcite.tools.FrameworkConfig;
import org.apache.hive.druid.org.apache.calcite.tools.RelBuilder;
import org.apache.hive.druid.org.apache.calcite.util.Util;

public class PigRelBuilder
extends RelBuilder {
    private String lastAlias;

    protected PigRelBuilder(Context context, RelOptCluster cluster, RelOptSchema relOptSchema) {
        super(context, cluster, relOptSchema);
    }

    public static PigRelBuilder create(FrameworkConfig config) {
        RelBuilder relBuilder = RelBuilder.create(config);
        return new PigRelBuilder(config.getContext(), relBuilder.cluster, relBuilder.relOptSchema);
    }

    @Override
    public PigRelBuilder scan(String ... tableNames) {
        this.lastAlias = null;
        return (PigRelBuilder)super.scan(tableNames);
    }

    @Override
    public PigRelBuilder scan(Iterable<String> tableNames) {
        this.lastAlias = null;
        return (PigRelBuilder)super.scan(tableNames);
    }

    public PigRelBuilder load(String path, RexNode loadFunction, RelDataType rowType) {
        this.scan(path.replace(".csv", ""));
        return this;
    }

    public PigRelBuilder distinct(Partitioner partitioner, int parallel) {
        this.distinct();
        return this;
    }

    public PigRelBuilder group(GroupOption option, Partitioner partitioner, int parallel, RelBuilder.GroupKey ... groupKeys) {
        return this.group(option, partitioner, parallel, ImmutableList.copyOf(groupKeys));
    }

    public PigRelBuilder group(GroupOption option, Partitioner partitioner, int parallel, Iterable<? extends RelBuilder.GroupKey> groupKeys) {
        ImmutableList<? extends RelBuilder.GroupKey> groupKeyList = ImmutableList.copyOf(groupKeys);
        this.validateGroupList(groupKeyList);
        int groupCount = ((RelBuilder.GroupKeyImpl)groupKeyList.get((int)0)).nodes.size();
        int n = groupKeyList.size();
        for (Ord<? extends RelBuilder.GroupKey> groupKey : Ord.reverse(groupKeyList)) {
            RelNode r = null;
            if (groupKey.i < n - 1) {
                r = this.build();
            }
            RexNode row = this.cluster.getRexBuilder().makeCall(this.peek(1, 0).getRowType(), SqlStdOperatorTable.ROW, this.fields());
            this.aggregate((RelBuilder.GroupKey)groupKey.e, this.aggregateCall(SqlStdOperatorTable.COLLECT, row).as(this.getAlias()));
            if (groupKey.i >= n - 1) continue;
            this.push(r);
            ArrayList<RexNode> predicates = new ArrayList<RexNode>();
            for (int key : Util.range(groupCount)) {
                predicates.add(this.equals(this.field(2, 0, key), this.field(2, 1, key)));
            }
            this.join(JoinRelType.INNER, this.and(predicates));
        }
        return this;
    }

    protected void validateGroupList(List<RelBuilder.GroupKeyImpl> groupKeyList) {
        if (groupKeyList.isEmpty()) {
            throw new IllegalArgumentException("must have at least one group");
        }
        int groupCount = groupKeyList.get((int)0).nodes.size();
        for (RelBuilder.GroupKeyImpl groupKey : groupKeyList) {
            if (groupKey.nodes.size() == groupCount) continue;
            throw new IllegalArgumentException("group key size mismatch");
        }
    }

    public String getAlias() {
        if (this.lastAlias != null) {
            return this.lastAlias;
        }
        RelNode top = this.peek();
        if (top instanceof TableScan) {
            return Util.last(top.getTable().getQualifiedName());
        }
        return null;
    }

    @Override
    public RelBuilder as(String alias) {
        this.lastAlias = alias;
        return super.as(alias);
    }

    public static enum GroupOption {
        MERGE,
        COLLECTED;

    }

    static interface Partitioner {
    }
}

