/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.sql.validate;

import java.util.ArrayList;
import java.util.List;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeFactoryImpl;
import org.apache.hive.druid.org.apache.calcite.schema.AggregateFunction;
import org.apache.hive.druid.org.apache.calcite.schema.FunctionParameter;
import org.apache.hive.druid.org.apache.calcite.sql.SqlAggFunction;
import org.apache.hive.druid.org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.hive.druid.org.apache.calcite.sql.SqlIdentifier;
import org.apache.hive.druid.org.apache.calcite.sql.SqlKind;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.hive.druid.org.apache.calcite.util.Optionality;
import org.apache.hive.druid.org.apache.calcite.util.Util;

public class SqlUserDefinedAggFunction
extends SqlAggFunction {
    public final AggregateFunction function;
    public final RelDataTypeFactory typeFactory;

    public SqlUserDefinedAggFunction(SqlIdentifier opName, SqlReturnTypeInference returnTypeInference, SqlOperandTypeInference operandTypeInference, SqlOperandTypeChecker operandTypeChecker, AggregateFunction function, boolean requiresOrder, boolean requiresOver, Optionality requiresGroupOrder, RelDataTypeFactory typeFactory) {
        super(Util.last(opName.names), opName, SqlKind.OTHER_FUNCTION, returnTypeInference, operandTypeInference, operandTypeChecker, SqlFunctionCategory.USER_DEFINED_FUNCTION, requiresOrder, requiresOver, requiresGroupOrder);
        this.function = function;
        this.typeFactory = typeFactory;
    }

    @Override
    public List<RelDataType> getParamTypes() {
        ArrayList<RelDataType> argTypes = new ArrayList<RelDataType>();
        for (FunctionParameter o : this.function.getParameters()) {
            RelDataType type = o.getType(this.typeFactory);
            argTypes.add(type);
        }
        return this.toSql(argTypes);
    }

    private List<RelDataType> toSql(List<RelDataType> types) {
        return Lists.transform(types, this::toSql);
    }

    private RelDataType toSql(RelDataType type) {
        if (type instanceof RelDataTypeFactoryImpl.JavaType && ((RelDataTypeFactoryImpl.JavaType)type).getJavaClass() == Object.class) {
            return this.typeFactory.createTypeWithNullability(this.typeFactory.createSqlType(SqlTypeName.ANY), true);
        }
        return JavaTypeFactoryImpl.toSql(this.typeFactory, type);
    }

    @Override
    public List<RelDataType> getParameterTypes(RelDataTypeFactory typeFactory) {
        return Lists.transform(this.function.getParameters(), parameter -> parameter.getType(typeFactory));
    }

    @Override
    public RelDataType getReturnType(RelDataTypeFactory typeFactory) {
        return this.function.getReturnType(typeFactory);
    }
}

