/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.sql.validate;

import java.util.List;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.hive.druid.org.apache.calcite.sql.SqlIdentifier;
import org.apache.hive.druid.org.apache.calcite.sql.SqlNode;
import org.apache.hive.druid.org.apache.calcite.sql.SqlNodeList;
import org.apache.hive.druid.org.apache.calcite.sql.SqlSelect;
import org.apache.hive.druid.org.apache.calcite.sql.validate.DelegatingScope;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlMoniker;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlNameMatcher;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlQualified;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlValidatorNamespace;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.hive.druid.org.apache.calcite.util.Static;

public class OrderByScope
extends DelegatingScope {
    private final SqlNodeList orderList;
    private final SqlSelect select;

    OrderByScope(SqlValidatorScope parent, SqlNodeList orderList, SqlSelect select) {
        super(parent);
        this.orderList = orderList;
        this.select = select;
    }

    @Override
    public SqlNode getNode() {
        return this.orderList;
    }

    @Override
    public void findAllColumnNames(List<SqlMoniker> result) {
        SqlValidatorNamespace ns = this.validator.getNamespace(this.select);
        this.addColumnNames(ns, result);
    }

    @Override
    public SqlQualified fullyQualify(SqlIdentifier identifier) {
        if (identifier.isSimple() && this.validator.config().sqlConformance().isSortByAlias()) {
            String name = (String)identifier.names.get(0);
            SqlValidatorNamespace selectNs = this.validator.getNamespace(this.select);
            RelDataType rowType = selectNs.getRowType();
            SqlNameMatcher nameMatcher = this.validator.catalogReader.nameMatcher();
            RelDataTypeField field = nameMatcher.field(rowType, name);
            int aliasCount = this.aliasCount(nameMatcher, name);
            if (aliasCount > 1) {
                throw this.validator.newValidationError(identifier, Static.RESOURCE.columnAmbiguous(name));
            }
            if (field != null && !field.isDynamicStar() && aliasCount == 1) {
                return SqlQualified.create(this, 1, selectNs, identifier);
            }
        }
        return super.fullyQualify(identifier);
    }

    private int aliasCount(SqlNameMatcher nameMatcher, String name) {
        int n = 0;
        for (SqlNode s : this.select.getSelectList()) {
            String alias = SqlValidatorUtil.getAlias(s, -1);
            if (alias == null || !nameMatcher.matches(alias, name)) continue;
            ++n;
        }
        return n;
    }

    @Override
    public RelDataType resolveColumn(String name, SqlNode ctx) {
        SqlValidatorNamespace selectNs = this.validator.getNamespace(this.select);
        RelDataType rowType = selectNs.getRowType();
        SqlNameMatcher nameMatcher = this.validator.catalogReader.nameMatcher();
        RelDataTypeField field = nameMatcher.field(rowType, name);
        if (field != null) {
            return field.getType();
        }
        SqlValidatorScope selectScope = this.validator.getSelectScope(this.select);
        return selectScope.resolveColumn(name, ctx);
    }

    @Override
    public void validateExpr(SqlNode expr) {
        SqlNode expanded = this.validator.expandOrderExpr(this.select, expr);
        this.parent.validateExpr(expanded);
    }
}

