/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.sql.validate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.google.common.collect.ImmutableCollection;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.org.apache.calcite.jdbc.CalciteSchema;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptSchema;
import org.apache.hive.druid.org.apache.calcite.prepare.Prepare;
import org.apache.hive.druid.org.apache.calcite.prepare.RelOptTableImpl;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.rel.type.StructKind;
import org.apache.hive.druid.org.apache.calcite.schema.Table;
import org.apache.hive.druid.org.apache.calcite.schema.Wrapper;
import org.apache.hive.druid.org.apache.calcite.sql.SqlCall;
import org.apache.hive.druid.org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.hive.druid.org.apache.calcite.sql.SqlDynamicParam;
import org.apache.hive.druid.org.apache.calcite.sql.SqlIdentifier;
import org.apache.hive.druid.org.apache.calcite.sql.SqlLiteral;
import org.apache.hive.druid.org.apache.calcite.sql.SqlNode;
import org.apache.hive.druid.org.apache.calcite.sql.SqlNodeList;
import org.apache.hive.druid.org.apache.calcite.sql.SqlWindow;
import org.apache.hive.druid.org.apache.calcite.sql.validate.AbstractNamespace;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SchemaNamespace;
import org.apache.hive.druid.org.apache.calcite.sql.validate.ScopeChild;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlMoniker;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlNameMatcher;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlQualified;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlValidator;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlValidatorNamespace;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlValidatorTable;
import org.apache.hive.druid.org.apache.calcite.sql.validate.TableNamespace;
import org.apache.hive.druid.org.apache.calcite.util.Pair;
import org.apache.hive.druid.org.apache.calcite.util.Static;
import org.apache.hive.druid.org.apache.calcite.util.Util;

class EmptyScope
implements SqlValidatorScope {
    protected final SqlValidatorImpl validator;

    EmptyScope(SqlValidatorImpl validator) {
        this.validator = validator;
    }

    @Override
    public SqlValidator getValidator() {
        return this.validator;
    }

    @Override
    public SqlQualified fullyQualify(SqlIdentifier identifier) {
        return SqlQualified.create(this, 1, null, identifier);
    }

    @Override
    public SqlNode getNode() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void resolve(List<String> names, SqlNameMatcher nameMatcher, boolean deep, SqlValidatorScope.Resolved resolved) {
    }

    @Override
    public SqlValidatorNamespace getTableNamespace(List<String> names) {
        SqlValidatorTable table = this.validator.catalogReader.getTable(names);
        return table != null ? new TableNamespace(this.validator, table) : null;
    }

    @Override
    public void resolveTable(List<String> names, SqlNameMatcher nameMatcher, SqlValidatorScope.Path path, SqlValidatorScope.Resolved resolved) {
        ArrayList<SqlValidatorScope.Resolve> imperfectResolves = new ArrayList<SqlValidatorScope.Resolve>();
        List<SqlValidatorScope.Resolve> resolves = ((SqlValidatorScope.ResolvedImpl)resolved).resolves;
        for (List<String> schemaPath : this.validator.catalogReader.getSchemaPaths()) {
            this.resolve_(this.validator.catalogReader.getRootSchema(), names, schemaPath, nameMatcher, path, resolved);
            for (SqlValidatorScope.Resolve resolve : resolves) {
                if (!resolve.remainingNames.isEmpty()) continue;
                ((SqlValidatorScope.ResolvedImpl)resolved).clear();
                resolves.add(resolve);
                return;
            }
            imperfectResolves.addAll(resolves);
        }
        if (resolves.isEmpty()) {
            resolves.addAll(imperfectResolves);
        }
    }

    private void resolve_(CalciteSchema rootSchema, List<String> names, List<String> schemaNames, SqlNameMatcher nameMatcher, SqlValidatorScope.Path path, SqlValidatorScope.Resolved resolved) {
        ImmutableCollection concat = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(schemaNames)).addAll(names)).build();
        CalciteSchema schema = rootSchema;
        AbstractNamespace namespace = null;
        Collection remainingNames = concat;
        for (String schemaName : concat) {
            if (schema == rootSchema && nameMatcher.matches(schemaName, schema.name)) {
                remainingNames = Util.skip(remainingNames);
                continue;
            }
            CalciteSchema subSchema = schema.getSubSchema(schemaName, nameMatcher.isCaseSensitive());
            if (subSchema != null) {
                path = path.plus(null, -1, subSchema.name, StructKind.NONE);
                remainingNames = Util.skip(remainingNames);
                schema = subSchema;
                namespace = new SchemaNamespace(this.validator, ImmutableList.copyOf(path.stepNames()));
                continue;
            }
            CalciteSchema.TableEntry entry = schema.getTable(schemaName, nameMatcher.isCaseSensitive());
            if (entry == null) {
                entry = schema.getTableBasedOnNullaryFunction(schemaName, nameMatcher.isCaseSensitive());
            }
            if (entry != null) {
                path = path.plus(null, -1, entry.name, StructKind.NONE);
                remainingNames = Util.skip(remainingNames);
                Table table = entry.getTable();
                SqlValidatorTable table2 = null;
                if (table instanceof Wrapper) {
                    table2 = ((Wrapper)((Object)table)).unwrap(Prepare.PreparingTable.class);
                }
                if (table2 == null) {
                    RelOptSchema relOptSchema = this.validator.catalogReader.unwrap(RelOptSchema.class);
                    RelDataType rowType = table.getRowType(this.validator.typeFactory);
                    table2 = RelOptTableImpl.create(relOptSchema, rowType, entry, null);
                }
                namespace = new TableNamespace(this.validator, table2);
                resolved.found(namespace, false, null, path, (List<String>)remainingNames);
                return;
            }
            if (namespace != null && !remainingNames.equals(names)) {
                resolved.found(namespace, false, null, path, (List<String>)remainingNames);
            }
            return;
        }
    }

    @Override
    public RelDataType nullifyType(SqlNode node, RelDataType type) {
        return type;
    }

    @Override
    public void findAllColumnNames(List<SqlMoniker> result) {
    }

    public void findAllTableNames(List<SqlMoniker> result) {
    }

    @Override
    public void findAliases(Collection<SqlMoniker> result) {
    }

    @Override
    public RelDataType resolveColumn(String name, SqlNode ctx) {
        return null;
    }

    @Override
    public SqlValidatorScope getOperandScope(SqlCall call) {
        return this;
    }

    @Override
    public void validateExpr(SqlNode expr) {
    }

    @Override
    public Pair<String, SqlValidatorNamespace> findQualifyingTableName(String columnName, SqlNode ctx) {
        throw this.validator.newValidationError(ctx, Static.RESOURCE.columnNotFound(columnName));
    }

    @Override
    public Map<String, ScopeChild> findQualifyingTableNames(String columnName, SqlNode ctx, SqlNameMatcher nameMatcher) {
        return ImmutableMap.of();
    }

    @Override
    public void addChild(SqlValidatorNamespace ns, String alias, boolean nullable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SqlWindow lookupWindow(String name) {
        return null;
    }

    @Override
    public SqlMonotonicity getMonotonicity(SqlNode expr) {
        return expr instanceof SqlLiteral || expr instanceof SqlDynamicParam || expr instanceof SqlDataTypeSpec ? SqlMonotonicity.CONSTANT : SqlMonotonicity.NOT_MONOTONIC;
    }

    @Override
    public SqlNodeList getOrderList() {
        return null;
    }
}

