/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.sql.type;

import java.util.List;
import java.util.Objects;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.hive.druid.org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeTransform;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.hive.druid.org.apache.calcite.util.Util;

public abstract class SqlTypeTransforms {
    public static final SqlTypeTransform TO_NULLABLE = (opBinding, typeToTransform) -> SqlTypeUtil.makeNullableIfOperandsAre(opBinding.getTypeFactory(), opBinding.collectOperandTypes(), Objects.requireNonNull(typeToTransform));
    public static final SqlTypeTransform TO_NULLABLE_ALL = (opBinding, type) -> {
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        return typeFactory.createTypeWithNullability(type, SqlTypeUtil.allNullable(opBinding.collectOperandTypes()));
    };
    public static final SqlTypeTransform TO_NOT_NULLABLE = (opBinding, typeToTransform) -> opBinding.getTypeFactory().createTypeWithNullability(Objects.requireNonNull(typeToTransform), false);
    public static final SqlTypeTransform FORCE_NULLABLE = (opBinding, typeToTransform) -> opBinding.getTypeFactory().createTypeWithNullability(Objects.requireNonNull(typeToTransform), true);
    public static final SqlTypeTransform LEAST_NULLABLE = (opBinding, typeToTransform) -> {
        for (RelDataType type : opBinding.collectOperandTypes()) {
            if (type.isNullable()) continue;
            return opBinding.getTypeFactory().createTypeWithNullability(typeToTransform, false);
        }
        return typeToTransform;
    };
    public static final SqlTypeTransform TO_VARYING = new SqlTypeTransform(){

        @Override
        public RelDataType transformType(SqlOperatorBinding opBinding, RelDataType typeToTransform) {
            switch (typeToTransform.getSqlTypeName()) {
                case VARCHAR: 
                case VARBINARY: {
                    return typeToTransform;
                }
            }
            SqlTypeName retTypeName = this.toVar(typeToTransform);
            RelDataType ret = opBinding.getTypeFactory().createSqlType(retTypeName, typeToTransform.getPrecision());
            if (SqlTypeUtil.inCharFamily(typeToTransform)) {
                ret = opBinding.getTypeFactory().createTypeWithCharsetAndCollation(ret, typeToTransform.getCharset(), typeToTransform.getCollation());
            }
            return opBinding.getTypeFactory().createTypeWithNullability(ret, typeToTransform.isNullable());
        }

        private SqlTypeName toVar(RelDataType type) {
            SqlTypeName sqlTypeName = type.getSqlTypeName();
            switch (sqlTypeName) {
                case CHAR: {
                    return SqlTypeName.VARCHAR;
                }
                case BINARY: {
                    return SqlTypeName.VARBINARY;
                }
                case ANY: {
                    return SqlTypeName.ANY;
                }
                case NULL: {
                    return SqlTypeName.NULL;
                }
            }
            throw Util.unexpected(sqlTypeName);
        }
    };
    public static final SqlTypeTransform TO_MULTISET_ELEMENT_TYPE = (opBinding, typeToTransform) -> typeToTransform.getComponentType();
    public static final SqlTypeTransform TO_MULTISET = (opBinding, typeToTransform) -> opBinding.getTypeFactory().createMultisetType(typeToTransform, -1L);
    public static final SqlTypeTransform ONLY_COLUMN = (opBinding, typeToTransform) -> {
        List<RelDataTypeField> fields = typeToTransform.getFieldList();
        assert (fields.size() == 1);
        return fields.get(0).getType();
    };
}

