/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.sql.ddl;

import java.util.List;
import org.apache.hive.druid.org.apache.calcite.sql.SqlCall;
import org.apache.hive.druid.org.apache.calcite.sql.SqlIdentifier;
import org.apache.hive.druid.org.apache.calcite.sql.SqlKind;
import org.apache.hive.druid.org.apache.calcite.sql.SqlNode;
import org.apache.hive.druid.org.apache.calcite.sql.SqlNodeList;
import org.apache.hive.druid.org.apache.calcite.sql.SqlOperator;
import org.apache.hive.druid.org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.hive.druid.org.apache.calcite.sql.SqlWriter;
import org.apache.hive.druid.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.hive.druid.org.apache.calcite.util.ImmutableNullableList;

public class SqlKeyConstraint
extends SqlCall {
    private static final SqlSpecialOperator UNIQUE = new SqlSpecialOperator("UNIQUE", SqlKind.UNIQUE);
    protected static final SqlSpecialOperator PRIMARY = new SqlSpecialOperator("PRIMARY KEY", SqlKind.PRIMARY_KEY);
    private final SqlIdentifier name;
    private final SqlNodeList columnList;

    SqlKeyConstraint(SqlParserPos pos, SqlIdentifier name, SqlNodeList columnList) {
        super(pos);
        this.name = name;
        this.columnList = columnList;
    }

    public static SqlKeyConstraint unique(SqlParserPos pos, SqlIdentifier name, SqlNodeList columnList) {
        return new SqlKeyConstraint(pos, name, columnList);
    }

    public static SqlKeyConstraint primary(SqlParserPos pos, SqlIdentifier name, SqlNodeList columnList) {
        return new SqlKeyConstraint(pos, name, columnList){

            @Override
            public SqlOperator getOperator() {
                return PRIMARY;
            }
        };
    }

    @Override
    public SqlOperator getOperator() {
        return UNIQUE;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.name, this.columnList);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        if (this.name != null) {
            writer.keyword("CONSTRAINT");
            this.name.unparse(writer, 0, 0);
        }
        writer.keyword(this.getOperator().getName());
        this.columnList.unparse(writer, 1, 1);
    }
}

