/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.sql.ddl;

import java.util.List;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.org.apache.calcite.schema.ColumnStrategy;
import org.apache.hive.druid.org.apache.calcite.sql.SqlCall;
import org.apache.hive.druid.org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.hive.druid.org.apache.calcite.sql.SqlIdentifier;
import org.apache.hive.druid.org.apache.calcite.sql.SqlKind;
import org.apache.hive.druid.org.apache.calcite.sql.SqlNode;
import org.apache.hive.druid.org.apache.calcite.sql.SqlOperator;
import org.apache.hive.druid.org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.hive.druid.org.apache.calcite.sql.SqlWriter;
import org.apache.hive.druid.org.apache.calcite.sql.parser.SqlParserPos;

public class SqlColumnDeclaration
extends SqlCall {
    private static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("COLUMN_DECL", SqlKind.COLUMN_DECL);
    public final SqlIdentifier name;
    public final SqlDataTypeSpec dataType;
    public final SqlNode expression;
    public final ColumnStrategy strategy;

    SqlColumnDeclaration(SqlParserPos pos, SqlIdentifier name, SqlDataTypeSpec dataType, SqlNode expression, ColumnStrategy strategy) {
        super(pos);
        this.name = name;
        this.dataType = dataType;
        this.expression = expression;
        this.strategy = strategy;
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableList.of(this.name, this.dataType);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        this.name.unparse(writer, 0, 0);
        this.dataType.unparse(writer, 0, 0);
        if (this.dataType.getNullable() != null && !this.dataType.getNullable().booleanValue()) {
            writer.keyword("NOT NULL");
        }
        if (this.expression != null) {
            switch (this.strategy) {
                case VIRTUAL: 
                case STORED: {
                    writer.keyword("AS");
                    this.exp(writer);
                    writer.keyword(this.strategy.name());
                    break;
                }
                case DEFAULT: {
                    writer.keyword("DEFAULT");
                    this.exp(writer);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("unexpected: " + (Object)((Object)this.strategy)));
                }
            }
        }
    }

    private void exp(SqlWriter writer) {
        if (writer.isAlwaysUseParentheses()) {
            this.expression.unparse(writer, 0, 0);
        } else {
            writer.sep("(");
            this.expression.unparse(writer, 0, 0);
            writer.sep(")");
        }
    }
}

