/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.sql;

import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.hive.druid.org.apache.calcite.sql.SqlCall;
import org.apache.hive.druid.org.apache.calcite.sql.SqlKind;
import org.apache.hive.druid.org.apache.calcite.sql.SqlNode;
import org.apache.hive.druid.org.apache.calcite.sql.SqlNodeList;
import org.apache.hive.druid.org.apache.calcite.sql.SqlWriter;
import org.apache.hive.druid.org.apache.calcite.sql.type.OperandTypes;
import org.apache.hive.druid.org.apache.calcite.sql.type.ReturnTypes;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlValidator;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.hive.druid.org.apache.calcite.util.Static;

public class SqlWithinGroupOperator
extends SqlBinaryOperator {
    public SqlWithinGroupOperator() {
        super("WITHIN GROUP", SqlKind.WITHIN_GROUP, 100, true, ReturnTypes.ARG0, null, (SqlOperandTypeChecker)OperandTypes.ANY_IGNORE);
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        assert (call.operandCount() == 2);
        ((SqlNode)call.operand(0)).unparse(writer, 0, 0);
        writer.keyword("WITHIN GROUP");
        SqlWriter.Frame orderFrame = writer.startList(SqlWriter.FrameTypeEnum.ORDER_BY_LIST, "(", ")");
        writer.keyword("ORDER BY");
        ((SqlNode)call.operand(1)).unparse(writer, 0, 0);
        writer.endList(orderFrame);
    }

    @Override
    public void validateCall(SqlCall call, SqlValidator validator, SqlValidatorScope scope, SqlValidatorScope operandScope) {
        assert (call.getOperator() == this);
        assert (call.operandCount() == 2);
        SqlCall aggCall = (SqlCall)call.operand(0);
        if (!aggCall.getOperator().isAggregator()) {
            throw validator.newValidationError(call, Static.RESOURCE.withinGroupNotAllowed(aggCall.getOperator().getName()));
        }
        SqlNodeList orderList = (SqlNodeList)call.operand(1);
        for (SqlNode order : orderList) {
            RelDataType nodeType = validator.deriveType(scope, order);
            assert (nodeType != null);
        }
        validator.validateAggregateParams(aggCall, null, orderList, scope);
    }

    @Override
    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        return this.validateOperands(validator, scope, call);
    }
}

